package common.ipdb.api.geoip;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigTools3;
import org.apache.commons.io.FileUtils;

import java.nio.file.Files;
import java.nio.file.Paths;


public class GeoIPConfig {

    /**
     * Get db file directory
     *
     * @return
     */
    public static String dbPath() {
        return ConfigTools3.getString("common.ipdb.path", getDefaultPath());
    }

    /**
     * Get Auto update or not
     *
     * @return
     */
    public static boolean dbAutoUpdate() {
        return ConfigTools3.getBoolean("common.ipdb.update.enable", true);
    }

    /**
     * Get DB file name
     *
     * @param type
     * @return
     */
    public static String dbFilename(EGeoIPDBType type) {
        return String.format("%s/%s", dbPath(), type.getName());
    }

    /**
     * Get download url by type
     *
     * @param type
     * @return
     */
    public static String dbDownloadUrl(EGeoIPDBType type) {
        String key = String.format("common.ipdb.download.%s", type.getType());
        return ConfigTools3.getString(key, getDefaultDownloadUrl(type));
    }

    /**
     * Check db file exist or not
     *
     * @param type
     * @return
     */
    public static boolean isDbExist(EGeoIPDBType type) {
        String dbFilename = dbFilename(type);
        return Files.exists(Paths.get(dbFilename)) || Files.exists(Paths.get(dbFilename + ".tmp"));
    }

    /**
     * Get backup file name
     *
     * @param fn
     * @return
     */
    public static String getFilenameBackup(String fn) {
        return String.format("%s.backup", fn);
    }

    /**
     * Get upgrade file name
     *
     * @param fn
     * @return
     */
    public static String getFilenameUpgrade(String fn) {
        return String.format("%s.upgrade", fn);
    }


    /**
     * 获取下载链接
     *
     * @param types
     * @return
     */
    private static String getDefaultDownloadUrl(EGeoIPDBType types) {
        return String.format("https://download.maxmind.com/app/geoip_download?edition_id=%s&license_key=b9uDk6Ou3z94frix&suffix=tar.gz", types.getType());
    }

    /**
     * 获取自动更新间隔
     *
     * @return
     */
    public static int updateDuration() {
        //默认7天
        return ConfigTools3.getInt("common.ipdb.update.duration", 7 * 24 * 60);
    }

    public static String getDBDownloadFilename(EGeoIPDBType types) {
        return String.format("%s/new-%s.tar.gz", dbPath(), types.getType());
    }

    public static String getDefaultPath() {
        //use user home directory as default
        String path = FileUtils.getUserDirectoryPath();
        if (Strings.isNullOrEmpty(path)) {
            return "./.valor/ipdb";
        } else {
            return path + "/.valor/ipdb";
        }
    }

    /**
     * 判断是否是window系统
     *
     * @return
     */
    public static boolean isOsWindows() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (!Strings.isNullOrEmpty(osName) && osName.contains("window")) {
            return true;
        }

        return false;
    }

}
