package common.ipdb.model;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;

/**
 * Ip AS(Autonomous System) info
 */
public class IPASNInfo {
    /**
     * Autonomous System Number
     * asn:iphub
     */
    @SerializedName(value = "ASN", alternate = {"asn"})
    private Integer ASN; //Autonomous System Number

    /**
     * Autonomous System organization
     * asn:isp
     */
    @SerializedName(value = "ASO")
    private String ASO;  //Autonomous System Organization

    public Integer getASN() {
        return ASN;
    }

    public void setASN(Integer ASN) {
        this.ASN = ASN;
    }

    public String getASO() {
        return ASO;
    }

    public void setASO(String ASO) {
        this.ASO = ASO;
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("ASN", ASN)
            .add("ASO", ASO)
            .toString();
    }
}
