/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.api;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import common.config.tools.config.ConfigTools3;
import common.ipdb.api.IIPDBApi;
import common.ipdb.api.geoip.GeoIPApi;
import common.ipdb.model.IPInfo;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPDBService {
    private static final Logger logger = LoggerFactory.getLogger(IPDBService.class);
    private static IIPDBApi ipQueryProvider;
    private static Cache<String, IPInfo> ipCache;

    public static void registerQueryProvider(IIPDBApi iIpQueryProvider) {
        if (ipQueryProvider != null) {
            ipQueryProvider = iIpQueryProvider;
        }
    }

    public static IPInfo get(String ip) {
        try {
            return (IPInfo)ipCache.get((Object)ip, k -> IPDBService.getFromIpdb(k));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPInfo getFromIpdb(String ip) {
        if (Objects.isNull(ipQueryProvider)) {
            ipQueryProvider = new GeoIPApi();
        }
        return ipQueryProvider.query(ip);
    }

    static {
        ipCache = Caffeine.newBuilder().expireAfterAccess((long)ConfigTools3.getInt((String)"common.ipdb.cache.expire.time", (Integer)720).intValue(), TimeUnit.MINUTES).maximumSize((long)ConfigTools3.getInt((String)"common.ipdb.cache.max.size", (Integer)640000).intValue()).build();
    }
}

