/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.api.geoip;

import com.google.common.collect.Maps;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import common.ipdb.api.geoip.EGeoIPDBType;
import common.ipdb.api.geoip.GeoIPConfig;
import common.ipdb.api.geoip.GeoIPService;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIPReaderFactory {
    private static final Logger logger = LoggerFactory.getLogger(GeoIPService.class);
    private static Map<EGeoIPDBType, DatabaseReader> dbReaderMap = Maps.newHashMap();

    public static void load(EGeoIPDBType type) {
        try {
            DatabaseReader reader = dbReaderMap.get((Object)type);
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            logger.info("Reader close exeption:{}", (Throwable)e);
        }
        String dbName = GeoIPConfig.dbFilename(type);
        try {
            GeoIPReaderFactory.updateDbIfNecessary(dbName);
            File dbFile = new File(dbName);
            if (!dbFile.exists()) {
                logger.info("DB[{}] not exist", (Object)dbFile);
            } else {
                Reader.FileMode fileMode = Reader.FileMode.MEMORY_MAPPED;
                if (GeoIPConfig.isOsWindows()) {
                    fileMode = Reader.FileMode.MEMORY;
                }
                DatabaseReader reader = new DatabaseReader.Builder(dbFile).fileMode(fileMode).withCache((NodeCache)new CHMCache()).build();
                dbReaderMap.put(type, reader);
                logger.info("DB[{}] is loaded", (Object)dbFile);
            }
        }
        catch (Exception e) {
            logger.error("DB[{}] load failed! ex[{}]", (Object)dbName, (Object)e);
        }
    }

    private static void updateDbIfNecessary(String filename) {
        String backupFilename = GeoIPConfig.getFilenameBackup(filename);
        String upgradeFilename = GeoIPConfig.getFilenameUpgrade(filename);
        try {
            Path upgrade;
            Path current = Paths.get(filename, new String[0]);
            if (Files.exists(current, new LinkOption[0])) {
                Files.copy(current, Paths.get(backupFilename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                logger.info("GeoIp db backup [{}]->[{}]", (Object)filename, (Object)backupFilename);
            }
            if (Files.exists(upgrade = Paths.get(upgradeFilename, new String[0]), new LinkOption[0])) {
                Files.move(upgrade, Paths.get(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                logger.info("GeoIp db update [{}]->[{}]", (Object)upgrade, (Object)filename);
            }
        }
        catch (Exception e) {
            logger.error("Update db field.Upgrade[{}] current[{}]", new Object[]{upgradeFilename, filename, e});
        }
    }

    public static DatabaseReader getReader(EGeoIPDBType type) {
        return dbReaderMap.get((Object)type);
    }

    public static boolean isEmpty() {
        return dbReaderMap.isEmpty();
    }
}

