/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.api.ipinfoio;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.config.tools.config.ConfigTools3;
import common.ipdb.api.IIPDBApi;
import common.ipdb.httptool.HCTools;
import common.ipdb.httptool.HttpResponse;
import common.ipdb.model.IPInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPInfoIOApi
implements IIPDBApi {
    private static final Logger logger = LoggerFactory.getLogger(IPInfoIOApi.class);
    private static Gson gson = new Gson();

    @Override
    public IPInfo query(String ip) {
        try {
            String apiUrlTpl = ConfigTools3.getString((String)"ipdb.api.ipinfo.url", (String)"http://ipinfo.io/%s/json");
            HttpResponse response = HCTools.get(String.format(apiUrlTpl, ip), null);
            if (response.getStatus() == 200 && !Strings.isNullOrEmpty((String)response.getBody())) {
                return (IPInfo)gson.fromJson(response.getBody(), IPInfo.class);
            }
        }
        catch (Exception e) {
            logger.error("IP[{}]", (Object)ip, (Object)e);
            return null;
        }
        return null;
    }
}

