package common.log;

/**
 * @author Frank.Huang
 */

public enum ELoggingProperty {
    //log path
    LOG_PATH,

    //log module name
    LOG_MODULE,
    // log file size
    LOG_FILE_SIZE,

    //info log count
    INFO_FILE_COUNT,

    //error log count
    ERROR_FILE_COUNT,

    //stat log count
    STAT_FILE_COUNT,

    //alarm log count
    ALARM_FILE_COUNT,

    //auto get log name 0:close 1:open
    LOG_AUTO_GET_NAME,

    LOG_PROPERTY_END;

    /**
     * check property is valid or not
     *
     * @param key
     * @return
     */
    public static boolean isValid(String key) {
        for (ELoggingProperty e : ELoggingProperty.values()) {
            if (e.name().contentEquals(key)) {
                return true;
            }
        }

        return false;
    }
}
