package common.log;

import com.google.common.base.Strings;
import org.slf4j.MDC;

public class MDCTools {

    public static void cleanMDC() {
        MDC.remove(MDCConstants.MDC_SESSION_ID);
        MDC.remove(MDCConstants.MDC_ALARM_ID);
        MDC.remove(MDCConstants.MDC_ACCOUNT_ID);
        MDC.remove(MDCConstants.MDC_ACCOUNT_NAME);
        MDC.remove(MDCConstants.MDC_LOG_SUMMARY);
    }

    public static void setMDC(String sessionId, String clientIp, String accountId, String accountName, String logSummary) {
        if (!Strings.isNullOrEmpty(sessionId)) {
            MDC.put(MDCConstants.MDC_SESSION_ID, sessionId);
        }

        if (!Strings.isNullOrEmpty(clientIp)) {
            MDC.put(MDCConstants.MDC_CLIENT_IP, clientIp);
        }

        if (!Strings.isNullOrEmpty(accountId)) {
            MDC.put(MDCConstants.MDC_ACCOUNT_ID, accountId);
        }

        if (!Strings.isNullOrEmpty(accountName)) {
            MDC.put(MDCConstants.MDC_ACCOUNT_NAME, accountName);
        }

        if (!Strings.isNullOrEmpty(logSummary)) {
            MDC.put(MDCConstants.MDC_LOG_SUMMARY, logSummary);
        }
    }
}
