/*
 * Decompiled with CFR 0.152.
 */
package common.log;

import com.google.common.base.Joiner;

public class LoggingMsgBuilder {
    private static final String FMT_LOG_MSG_COMMON = "[%s] [%s] [%s] [%s] [%s] %s";
    private static final String FMT_LOG_MSG_ALARM = "[%s] [%s] [%s] [%s] [%s] [%s] %s";
    private static final String FMT_LOG_MSG_STAT = "%s";
    private static final String FMT_LOG_MSG_STAT_KV = "%s:%s";
    private static final String FMT_LOG_MSG_STAT_TIME = "%s:%s:%s %s";

    public static String formatParams(String ... params) {
        return Joiner.on((String)"|").skipNulls().join((Object[])params);
    }

    public static String buildMsg(String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        String paramStr = LoggingMsgBuilder.formatParams(params);
        String msg = String.format(FMT_LOG_MSG_COMMON, sessionId, clientIp, accountId, accountName, logSummary, paramStr);
        return msg;
    }

    public static String buildAlarmMsg(String sessionId, String clientIp, String accountId, String accountName, String alarmId, String logSummary, String ... params) {
        String paramStr = LoggingMsgBuilder.formatParams(params);
        String msg = String.format(FMT_LOG_MSG_ALARM, sessionId, clientIp, accountId, accountName, alarmId, logSummary, paramStr);
        return msg;
    }

    public static String buildStatMsg(String msg) {
        return String.format(FMT_LOG_MSG_STAT, msg);
    }

    public static String buildStatMsg(String key, String value) {
        return String.format(FMT_LOG_MSG_STAT_KV, key, value);
    }

    public static String buildStatMsg(String key, String value, long time, String ... params) {
        String paramStr = LoggingMsgBuilder.formatParams(params);
        String msg = String.format(FMT_LOG_MSG_STAT_TIME, key, value, time, paramStr);
        return msg;
    }
}

