/*
 * Decompiled with CFR 0.152.
 */
package common.log.filter;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class HttpTools {
    private static ImmutableList<String> ipHeaderNameList = ImmutableList.builder().add((Object)"x-forwarded-for").add((Object)"CF-Connecting-IP").add((Object)"Proxy-Client-IP").add((Object)"WL-Proxy-Client-IP").add((Object)"X-Forwarded-For").add((Object)"HTTP_X_REAL_IP").add((Object)"HTTP_CLIENT_IP").add((Object)"HTTP_X_FORWARDED_FOR").build();

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty((String)clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }

    public static String getClientIp(HttpServletRequest request) {
        int pos;
        String headerName;
        String remoteHost = null;
        UnmodifiableIterator unmodifiableIterator = ipHeaderNameList.iterator();
        while (unmodifiableIterator.hasNext() && !HttpTools.isInvalidClientIp(remoteHost = request.getHeader(headerName = (String)unmodifiableIterator.next()))) {
        }
        if (!HttpTools.isInvalidClientIp(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteHost) && (pos = remoteHost.indexOf(",")) > 0) {
            remoteHost = remoteHost.substring(0, pos);
        }
        return Strings.nullToEmpty((String)remoteHost);
    }

    public static String getParameter(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        return request.getParameter(key);
    }

    public static String getCookie(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        Cookie[] cookies = request.getCookies();
        if (Objects.nonNull(cookies)) {
            for (Cookie cookie : cookies) {
                if (!key.contentEquals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    public static String getHeader(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        return Strings.nullToEmpty((String)request.getHeader(key));
    }

    public static String getHttpParameter(HttpServletRequest request, String key) {
        String value = HttpTools.getCookie(request, key);
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = HttpTools.getParameter(request, key);
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = HttpTools.getHeader(request, key);
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }
}

