package common.log;

/**
 * @author Frank.Huang
 */

public enum ELoggingProperty {
    //log path
    LOG_PATH,

    //log module name
    LOG_MODULE,



    //info log count
    @Deprecated
    INFO_FILE_COUNT,

    //error log count
    @Deprecated
    ERROR_FILE_COUNT,

    //stat log count
    @Deprecated
    STAT_FILE_COUNT,

    //alarm log count
    @Deprecated
    ALARM_FILE_COUNT,

    //auto get log name 0:close 1:open
    LOG_AUTO_GET_NAME,

    // log file size
    LOG_FILE_SIZE,

    //File count per day
    DAILY_FILE_COUNT,

    //Max history day
    MAX_HISTORY_DAYS,

    //Max file size
    MAX_FILE_SIZE_INFO,
    MAX_FILE_SIZE_ERROR,
    MAX_FILE_SIZE_ALARM,
    MAX_FILE_SIZE_STAT,

    LOG_PROPERTY_END;

    /**
     * check property is valid or not
     *
     * @param key
     * @return
     */
    public static boolean isValid(String key) {
        for (ELoggingProperty e : ELoggingProperty.values()) {
            if (e.name().contentEquals(key)) {
                return true;
            }
        }

        return false;
    }
}
