/*
 * Decompiled with CFR 0.152.
 */
package common.log;

import com.google.common.base.Strings;
import common.log.ELoggingProperty;
import common.log.LoggingMsgBuilder;
import common.log.LoggingTools;
import common.log.MDCTools;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.config.Configurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class Logging {
    private static final Marker MARKER_STAT = MarkerFactory.getMarker((String)"STAT");
    private static final Marker MARKER_ALARM = MarkerFactory.getMarker((String)"ALARM");
    private static String logName = "";

    public static Logging setLogName(String name) {
        if (!Strings.isNullOrEmpty((String)name)) {
            logName = name;
        }
        return null;
    }

    public static void setLoggerProperty(String key, String value) {
        if (Strings.isNullOrEmpty((String)key) || Strings.isNullOrEmpty((String)value)) {
            return;
        }
        System.setProperty(key, value);
        System.out.println(String.format("*** Set log property key=[%s] value=[%s]", key, value));
    }

    public static void setLoggerProperties(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (ELoggingProperty.isValid(entry.getKey())) {
                Logging.setLoggerProperty(entry.getKey(), entry.getValue());
                continue;
            }
            System.out.println(String.format("*** Invalid property key=[%s] value=[%s]", entry.getKey(), entry.getValue()));
        }
    }

    public static void initialize(String moduleName, String fileName) {
        if (!Strings.isNullOrEmpty((String)moduleName)) {
            Logging.setLoggerProperty("LOG_MODULE", moduleName);
        }
        if (Strings.isNullOrEmpty((String)fileName)) {
            fileName = "config/log4j2.xml";
        }
        if (Paths.get(fileName, new String[0]).toFile().isFile()) {
            Configurator.initialize(null, (String)fileName);
            System.out.println(String.format("Load log config file:[%s]", fileName));
        } else {
            System.out.println(String.format("Config file:[%s] not exist,use default", fileName));
        }
    }

    private static String getLogName() {
        StackTraceElement caller;
        if (!Strings.isNullOrEmpty((String)logName)) {
            return logName;
        }
        String autoGetName = System.getProperty("LOG_AUTO_GET_NAME");
        if (!Strings.isNullOrEmpty((String)autoGetName) && "1".contentEquals(autoGetName) && Objects.nonNull(caller = LoggingTools.findCaller())) {
            return String.format("%s.%s", caller.getClassName(), caller.getMethodName() + ":" + caller.getLineNumber());
        }
        return Logging.class.getName();
    }

    public static Logger getLogger() {
        return LoggerFactory.getLogger((String)Logging.getLogName());
    }

    public static Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger((String)clazz.getName());
    }

    public void info(String msg) {
        Logging.getLogger().info(msg);
    }

    public void info(String format, Object ... params) {
        Logging.getLogger().info(format, params);
    }

    public void info(String msg, Throwable t) {
        Logging.getLogger().info(msg, t);
    }

    public static void info(String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isInfoEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().info(LoggingMsgBuilder.formatParams(params));
        MDCTools.cleanMDC();
    }

    public static void info2(String logSummary, String ... params) {
        if (!Logging.getLogger().isInfoEnabled()) {
            return;
        }
        MDC.put((String)"logSummary", (String)logSummary);
        Logging.getLogger().info(LoggingMsgBuilder.formatParams(params));
        MDC.remove((String)"logSummary");
    }

    public static void info(Throwable t, String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isInfoEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().info(LoggingMsgBuilder.formatParams(params), t);
        MDCTools.cleanMDC();
    }

    public void warn(String msg) {
        Logging.getLogger().info(msg);
    }

    public void warn(String format, Object ... params) {
        Logging.getLogger().info(format, params);
    }

    public void warn(String msg, Throwable t) {
        Logging.getLogger().info(msg, t);
    }

    public static void wran2(String logSummary, String ... params) {
        if (!Logging.getLogger().isInfoEnabled()) {
            return;
        }
        MDC.put((String)"logSummary", (String)logSummary);
        Logging.getLogger().warn(LoggingMsgBuilder.formatParams(params));
        MDC.remove((String)"logSummary");
    }

    public static void warn(String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isWarnEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().warn(LoggingMsgBuilder.formatParams(params));
        MDCTools.cleanMDC();
    }

    public static void warn(Throwable e, String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isWarnEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().warn(LoggingMsgBuilder.formatParams(params), e);
        MDCTools.cleanMDC();
    }

    public void error(String msg) {
        Logging.getLogger().info(msg);
    }

    public void error(String format, Object ... params) {
        Logging.getLogger().info(format, params);
    }

    public void error(String msg, Throwable t) {
        Logging.getLogger().info(msg, t);
    }

    public static void error(String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isErrorEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().error(LoggingMsgBuilder.formatParams(params));
        MDCTools.cleanMDC();
    }

    public static void error(Throwable e, String sessionId, String clientIp, String accountId, String accountName, String logSummary, String ... params) {
        if (!Logging.getLogger().isErrorEnabled()) {
            return;
        }
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        Logging.getLogger().error(LoggingMsgBuilder.formatParams(params), e);
        MDCTools.cleanMDC();
    }

    public static void error2(String logSummary, String ... params) {
        if (!Logging.getLogger().isInfoEnabled()) {
            return;
        }
        MDC.put((String)"logSummary", (String)logSummary);
        Logging.getLogger().warn(LoggingMsgBuilder.formatParams(params));
        MDC.remove((String)"logSummary");
    }

    public static void stat(String msg) {
        Logging.getLogger().info(MARKER_STAT, LoggingMsgBuilder.buildStatMsg(msg));
    }

    public static void stat(String key, String value) {
        Logging.stat(LoggingMsgBuilder.buildStatMsg(key, value));
    }

    public static void stat(String key, String value, long time, String ... params) {
        Logging.stat(LoggingMsgBuilder.buildStatMsg(key, value, time, params));
    }

    public static void alarm(String sessionId, String clientIp, String accountId, String accountName, String alarmId, String logSummary, String ... params) {
        if (!Logging.getLogger().isErrorEnabled()) {
            return;
        }
        String msg = LoggingMsgBuilder.formatParams(params);
        MDCTools.setMDC(sessionId, clientIp, accountId, accountName, logSummary);
        MDC.put((String)"alarmId", (String)alarmId);
        Logging.getLogger().info(MARKER_ALARM, msg);
        MDC.remove((String)"alarmId");
        MDCTools.cleanMDC();
    }
}

