/*
 * Decompiled with CFR 0.152.
 */
package common.log.filter;

import com.google.common.base.Strings;
import common.log.filter.HttpTools;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;

public class MDCServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.insertIntoMDC(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.clearMDC();
        }
    }

    public void destroy() {
    }

    private void insertIntoMDC(ServletRequest request) {
        MDC.put((String)"sessionId", (String)this.getSessionId((HttpServletRequest)request));
        MDC.put((String)"clientIp", (String)HttpTools.getClientIp((HttpServletRequest)request));
        MDC.put((String)"accountId", (String)this.getAccountId((HttpServletRequest)request));
        MDC.put((String)"accountName", (String)this.getAccountName((HttpServletRequest)request));
    }

    private void clearMDC() {
        MDC.remove((String)"sessionId");
        MDC.remove((String)"clientIp");
        MDC.remove((String)"accountId");
        MDC.remove((String)"accountName");
    }

    private String getSessionId(HttpServletRequest request) {
        return HttpTools.getHttpParameter(request, "sessionId");
    }

    private String getAccountId(HttpServletRequest request) {
        String value = HttpTools.getHttpParameter(request, "accountId");
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "uid");
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }

    private String getAccountName(HttpServletRequest request) {
        String value = HttpTools.getHttpParameter(request, "accountName");
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "mac");
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        value = HttpTools.getHttpParameter(request, "did");
        if (!Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        return "";
    }
}

