package common.session.configuration;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

import javax.sql.DataSource;
import java.util.Properties;

@Configuration
public class SessionDBConfiguration extends AbstractDBCfgWithHikariCP {
    private static final Logger logger = LoggerFactory.getLogger(SessionDBConfiguration.class);
    public static final String DATABASE_MODEL_BASE_PACKAGE = "common.session";
    private static final String AES_KEY = "Ebw6MyVpHAC23ZMszboDDQ";
    private String host = ConfigAESTools.getAESString("common.session.db.host", AES_KEY);
    private String inst = ConfigAESTools.getAESString("common.session.db.inst", AES_KEY);
    private String user = ConfigAESTools.getAESString("common.session.db.user", AES_KEY);
    private String pass = ConfigAESTools.getAESString("common.session.db.pass", AES_KEY);
    private String appendPackagesToScan = ConfigTools3.getString("common.session.db.appendPackagesToScan");

    public SessionDBConfiguration() {
    }

    private String getConnectUrl() {
        if (!Strings.isNullOrEmpty(host) && !Strings.isNullOrEmpty(inst) && !Strings.isNullOrEmpty(user) && !Strings.isNullOrEmpty(pass)) {
            return "jdbc:mysql://" + host + "/" + inst + "?" + "useUnicode=true&characterEncoding=utf8&autoReconnect=true";
        } else {
            logger.error("{}-{}-{}-{}", new Object[]{host, inst, user, pass});
            throw new IllegalArgumentException("Invalid parameter");
        }
    }

    @Bean(destroyMethod = "close", name = "cscDataSource")
    public DataSource cscDataSource() {
        logger.info("Connect database:{}-{}-{}", new Object[]{host, inst, user});
        return getDataSource(getConnectUrl(), user, pass);
    }

    @Bean(name = "cscSessionFactory", destroyMethod = "destroy")
    @Qualifier(value = "cscSessionFactory")
    public FactoryBean<SessionFactory> cscSessionFactory() {
//        return Strings.isNullOrEmpty(appendPackagesToScan) ? getSessionFactory(cscDataSource(), DATABASE_MODEL_BASE_PACKAGE) : getSessionFactory(cscDataSource(), DATABASE_MODEL_BASE_PACKAGE, appendPackagesToScan);
        return getSessionFactory(cscDataSource(), DATABASE_MODEL_BASE_PACKAGE);
    }

    @Bean(name = "cscTransactionManager")
    @Qualifier(value = "cscTransactionManager")
    public PlatformTransactionManager cscTransactionManager() throws Exception {
        return getTransactionManager((SessionFactory) cscSessionFactory().getObject(), 1800);
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource cscDataSource, String... scanPackages) {
        return super.getSessionFactory(cscDataSource, scanPackages);
    }

    public PlatformTransactionManager getTransactionManager(SessionFactory cscSessionFactory, int txTimeout) throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(cscSessionFactory);
        transactionManager.setDefaultTimeout(txTimeout);
        return transactionManager;
    }

    public Properties getDBProperties() {
        Properties props = super.getDBProperties();
        useL2Cache = ConfigTools3.getBoolean("common.session.db.useL2Cache", false);
        logger.info("Use L2 Cache:[{}]", useL2Cache);
        props.put("hibernate.cache.use_second_level_cache", useL2Cache);
        if (useL2Cache) {
            props.put("hibernate.cache.region.factory_class", l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", useQueryCache);
        }

        props.put("hibernate.hbm2ddl.auto", hbm2ddlAuto);
        return props;
    }
}

