package common.session.model.dao;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.valor.mfc.vms.common.database.tool.access.AbstractBaseDao;
import com.valor.mfc.vms.common.database.tool.access.SqlScalars;
import com.valor.mfc.vms.common.database.tool.access.constants.EOperator;
import com.valor.mfc.vms.common.database.tool.access.constants.ESqlOrder;
import common.base.tools.stat.StatTools;
import common.base.tools.type.CollectionUtils;
import common.session.service.impl.SessionServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.*;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.*;

@Repository
@Transactional(value = "cscTransactionManager")
public class SessionBaseDao {
    private static final Logger logger = LoggerFactory.getLogger(SessionBaseDao.class);

    SessionBaseDao(){
        System.out.println(this.getClass().getName());
    }
    @Autowired
    protected SessionFactory cscSessionFactory;


    public Session currentSession() {
        return cscSessionFactory.getCurrentSession();
    }


    /**
     * 获取条件的过滤值
     *
     * @param returnType
     * @param filters
     * @return
     */

    @Transactional(value = "cscTransactionManager")
    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
        System.out.println("getData");
        Criteria criteria = currentSession().createCriteria(returnType);
        criteria.setReadOnly(false);
        criteria.setCacheable(enableCahce);
        if (filters != null) {
            for (Map.Entry entry : filters.entrySet()) {
                criteria.add(Restrictions.eq((String) entry.getKey(), entry.getValue()));
            }
        }
        System.out.println("getData");
        return criteria.uniqueResult();
    }

    /**
     * 获取简单的list列表
     *
     * @param returnType
     * @param filters
     * @return
     */

    @Transactional(value = "cscTransactionManager")
    public List getListData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        System.out.println("getListData1");
        Criteria criteria = currentSession().createCriteria(returnType);
        criteria.setReadOnly(false);
        criteria.setCacheable(enableCache);
        if (filters != null) {
            for (Map.Entry entry : filters.entrySet()) {
                criteria.add(Restrictions.eq((String) entry.getKey(), entry.getValue()));
            }
        }

        List list = criteria.list();
        System.out.println("getListData2");
        return list;
    }


    public List getListDataIn(boolean enableCache,Class returnType, Map<String,Object> filters){
        Criteria criteria = currentSession().createCriteria(returnType);
        criteria.setReadOnly(false);
        criteria.setCacheable(enableCache);
        if (filters!=null){
            for (Map.Entry entry : filters.entrySet()){
                if (entry.getValue() instanceof Collection){
                    criteria.add(Restrictions.in((String) entry.getKey(),((Collection) entry.getValue()).toArray()));
                }else {
                    criteria.add(Restrictions.eq((String) entry.getKey(), entry.getValue()));
                }
            }
        }

        List list = criteria.list();
        return list;
    }


    public List getDataList(boolean enableCache, Class returnType, Map<EOperator, Map<String, Object>> filters) {
        Criteria criteria = currentSession().createCriteria(returnType);
        criteria.setReadOnly(true);
        criteria.setCacheable(enableCache);
        if (filters != null) {
            Iterator iterator = filters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry) iterator.next();
                if (EOperator.EQ.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.eq(e.getKey(), e.getValue()));
                    }
                } else if (EOperator.NE.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.ne(e.getKey(), e.getValue()));
                    }
                } else if (EOperator.GT.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.gt(e.getKey(), e.getValue()));
                    }
                } else if (EOperator.GE.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.ge(e.getKey(), e.getValue()));
                    }
                } else if (EOperator.LT.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.lt(e.getKey(), e.getValue()));
                    }
                } else if (EOperator.LE.equals(entry.getKey())) {
                    for (Map.Entry<String, Object> e : ((Map<String, Object>) entry.getValue()).entrySet()) {
                        criteria.add(Restrictions.le(e.getKey(), e.getValue()));
                    }
                }
            }
        }

        List list = criteria.list();
        return list;
    }


    /////////////////////////////////////////////// 以下所有方法为重写  //////////////////////////////////////////
    //////////////////////////////////////////////// 尝试解决 no transaction is in progress 异常////////////////

    public void flushAndClear() {
        Session session = this.currentSession();
        session.flush();
        session.clear();
    }

    @Transactional(value = "cscTransactionManager")
    public void storeEntity(Object entity) {
        System.out.println("1");
         if (entity != null) {
            this.currentSession().saveOrUpdate(entity);
        }
        System.out.println("2");
    }

    public void storeEntityIfAbsent(Object entity) {
        Session session = this.currentSession();
        this.doStoreEntityIfAbsent(entity, session);
    }

    private void doStoreEntityIfAbsent(Object entity, Session session) {
        boolean exists = session.contains(entity);
        if (!exists) {
            session.saveOrUpdate(entity);
        }

    }

    public Object mergeEntity(Object entity) {
        return this.currentSession().merge(entity);
    }

    public void mergeAll(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            Iterator var3 = entities.iterator();

            while(var3.hasNext()) {
                Object entity = var3.next();
                session.merge(entity);
            }
        }

    }

    @Transactional(value = "cscTransactionManager")
    public void storeAll(Collection entities) {
        System.out.println("3");
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            Iterator var3 = entities.iterator();

            while(var3.hasNext()) {
                Object entity = var3.next();
                session.saveOrUpdate(entity);
            }
        }
        System.out.println("4");
    }

    public void storeAllIfAbsent(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            Iterator var3 = entities.iterator();

            while(var3.hasNext()) {
                Object entity = var3.next();
                this.doStoreEntityIfAbsent(entity, session);
            }
        }

    }

    public void deleteAll(Collection entities) {
        if (entities != null && !entities.isEmpty()) {
            Session session = this.currentSession();
            Iterator var3 = entities.iterator();

            while(var3.hasNext()) {
                Object entity = var3.next();
                session.delete(entity);
            }
        }

    }

    public void saveEntity(Object entity) {
        this.currentSession().save(entity);
    }

    public void updateEntity(Object entity) {
        this.currentSession().update(entity);
    }

    public void deleteEntity(Object entity) {
        this.currentSession().delete(entity);
    }

    public <T> T getById(Class<T> entityClass, Serializable id) {
        return this.currentSession().get(entityClass, id);
    }

    public <T> T getByNaturalId(Class<? extends T> entityClass, String field, String name) {
        return this.currentSession().byNaturalId(entityClass).using(field, name).load();
    }

//    public <T> T getByNaturalIdCaseInsensitive(Class<? extends T> entityClass, String field, String name) {
//        StringBuilder sb = new StringBuilder();
//        sb.append("from ");
//        sb.append(entityClass.getSimpleName());
//        sb.append(" where lower(").append(field).append(") = :name) { ");
//        Map<String, Object> params = Collections.singletonMap("name", name.toLowerCase());
//        return this.findUniqueByNamedParameters(sb, params);
//    }

    protected static String convertRowElementToString(Object rowElement) {
        if (rowElement == null) {
            return null;
        } else {
            return rowElement instanceof String ? (String)rowElement : rowElement.toString();
        }
    }

    protected static Integer convertRowElementToInteger(Object rowElement) {
        if (rowElement == null) {
            return 0;
        } else {
            return StringUtils.isNumeric(rowElement.toString()) ? Integer.valueOf(rowElement.toString()) : 0;
        }
    }

    protected static Long convertRowElementToLong(Object rowElement) {
        if (rowElement == null) {
            return 0L;
        } else {
            return StringUtils.isNumeric(rowElement.toString()) ? Long.valueOf(rowElement.toString()) : 0L;
        }
    }

    protected static Date convertRowElementToDate(Object rowElement) {
        if (rowElement == null) {
            return null;
        } else {
            return rowElement instanceof Date ? (Date)rowElement : null;
        }
    }

    protected static Timestamp convertRowElementToTimestamp(Object rowElement) {
        if (rowElement == null) {
            return null;
        } else {
            return rowElement instanceof Timestamp ? (Timestamp)rowElement : null;
        }
    }

    protected static BigDecimal convertRowElementToBigDecimal(Object rowElement) {
        if (rowElement == null) {
            return BigDecimal.ZERO;
        } else {
            return rowElement instanceof BigDecimal ? (BigDecimal)rowElement : new BigDecimal(rowElement.toString());
        }
    }

    protected static void applyNamedParameterToQuery(Query queryObject, String paramName, Object value) throws HibernateException {
        if (value instanceof Collection) {
            queryObject.setParameterList(paramName, (Collection)value);
        } else if (value instanceof Object[]) {
            queryObject.setParameterList(paramName, (Object[])((Object[])value));
        } else if (value instanceof String) {
            queryObject.setString(paramName, (String)value);
        } else {
            queryObject.setParameter(paramName, value);
        }

    }

    public List find(CharSequence queryString) {
        Query queryObject = this.currentSession().createQuery(queryString.toString());
        queryObject.setCacheable(true);
        return queryObject.list();
    }

    public List findById(CharSequence queryString, Long id) {
        Query queryObject = this.currentSession().createQuery(queryString.toString());
        queryObject.setCacheable(true);
        queryObject.setParameter("id", id);
        return queryObject.list();
    }

    public List findByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        Iterator var4 = params.entrySet().iterator();

        while(var4.hasNext()) {
            Map.Entry<String, Object> param = (Map.Entry)var4.next();
            applyNamedParameterToQuery(query, (String)param.getKey(), param.getValue());
        }

        return query.list();
    }

    public Object findUniqueByNamedParameters(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        Iterator var4 = params.entrySet().iterator();

        while(var4.hasNext()) {
            Map.Entry<String, Object> param = (Map.Entry)var4.next();
            applyNamedParameterToQuery(query, (String)param.getKey(), param.getValue());
        }

        return query.uniqueResult();
    }

    public int executeUpdate(CharSequence queryCharSequence) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        return query.executeUpdate();
    }

    public int executeUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        Query query = this.currentSession().createQuery(queryCharSequence.toString());
        query.setCacheable(true);
        Iterator var4 = params.entrySet().iterator();

        while(var4.hasNext()) {
            Map.Entry<String, Object> param = (Map.Entry)var4.next();
            applyNamedParameterToQuery(query, (String)param.getKey(), param.getValue());
        }

        return query.executeUpdate();
    }

    public int executeSqlUpdate(CharSequence queryCharSequence) {
        SQLQuery query = this.currentSession().createSQLQuery(queryCharSequence.toString());
        query.setCacheable(true);
        return query.executeUpdate();
    }

    public int executeSqlUpdate(CharSequence queryCharSequence, Map<String, Object> params) {
        SQLQuery query = this.currentSession().createSQLQuery(queryCharSequence.toString());
        query.setCacheable(true);
        Iterator var4 = params.entrySet().iterator();

        while(var4.hasNext()) {
            Map.Entry<String, Object> param = (Map.Entry)var4.next();
            applyNamedParameterToQuery(query, (String)param.getKey(), param.getValue());
        }

        return query.executeUpdate();
    }
    private void setResultTransformer(Class T, SQLQuery query) {
        if (T != null && !T.equals(String.class) && !T.equals(Long.class) && !T.equals(Integer.class) && !T.equals(Object[].class)) {
            query.setResultTransformer(Transformers.aliasToBean(T));
        }

    }

    public <T> List<T> query(Class T, SqlScalars sqlScalars, int firstResult, int maxResult) {
        SQLQuery query = sqlScalars.createSqlQuery(this.currentSession());
        query.setReadOnly(true);
        this.setResultTransformer(T, query);
        sqlScalars.populateScalars(query);
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResult);
        return query.list();
    }

//    public List getDataList(boolean enableCache, Class returnType, Map<EOperator, Map<String, Object>> filters) {
//        return Lists.newArrayList();
//    }
//
//    public List getListData(boolean enableCache, Class returnType, Map<String, Object> filters) {
//        Criteria criteria = this.currentSession().createCriteria(returnType);
//        criteria.setReadOnly(true);
//        criteria.setCacheable(enableCache);
//        if (filters != null) {
//            Iterator var5 = filters.entrySet().iterator();
//
//            while(var5.hasNext()) {
//                Map.Entry entry = (Map.Entry)var5.next();
//                criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
//            }
//        }
//
//        List list = criteria.list();
//        return list;
//    }

//    public List getListDataIn(boolean enableCache, Class returnType, Map<String, Object> filters) {
//        Criteria criteria = this.currentSession().createCriteria(returnType);
//        criteria.setReadOnly(true);
//        criteria.setCacheable(enableCache);
//        if (filters != null) {
//            Iterator var5 = filters.entrySet().iterator();
//
//            while(var5.hasNext()) {
//                Map.Entry entry = (Map.Entry)var5.next();
//                if (entry.getValue() instanceof Collection) {
//                    criteria.add(Restrictions.in((String)entry.getKey(), ((Collection)entry.getValue()).toArray()));
//                } else {
//                    criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
//                }
//            }
//        }
//
//        List list = criteria.list();
//        return list;
//    }

    public Set getSetData(boolean enableCache, Class returnType, Map<String, Object> filters) {
        return new HashSet(this.getListData(enableCache, returnType, filters));
    }

//    public Object getData(boolean enableCahce, Class returnType, Map<String, Object> filters) {
//        Criteria criteria = this.currentSession().createCriteria(returnType);
//        criteria.setReadOnly(true);
//        criteria.setCacheable(enableCahce);
//        if (filters != null) {
//            Iterator var5 = filters.entrySet().iterator();
//
//            while(var5.hasNext()) {
//                Map.Entry entry = (Map.Entry)var5.next();
//                criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
//            }
//        }
//
//        return criteria.uniqueResult();
//    }

    public int excuteSql(String sql) {
        return this.currentSession().createSQLQuery(sql).executeUpdate();
    }

    public int excuteQueryCount(String sql) {
        try {
            return ((BigInteger)this.currentSession().createSQLQuery(sql).uniqueResult()).intValue();
        } catch (Exception var3) {
            logger.info("query count exception! sql={} exception:{}", sql, var3);
            return -1;
        }
    }

    public long criteriaQueryCount(Class valueType) {
        return this.criteriaQueryCount(valueType, false);
    }

    public long criteriaQueryCount(Class valueType, boolean cacheable) {
        StatTools.startDBTimer("count-" + valueType.getSimpleName());
        Long ret = (Long)this.currentSession().createCriteria(valueType).setReadOnly(true).setCacheable(cacheable).setProjection(Projections.rowCount()).uniqueResult();
        StatTools.startDBTimer("count-" + valueType.getSimpleName());
        return ret;
    }

    public long criteriaQueryCount(Class valueType, Map<String, Object> filter) {
        Criteria criteria = this.currentSession().createCriteria(valueType);
        if (filter != null) {
            Iterator var4 = filter.entrySet().iterator();

            while(var4.hasNext()) {
                Map.Entry entry = (Map.Entry)var4.next();
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)entry.getValue()));
                } else {
                    criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
                }
            }
        }

        criteria.setProjection(Projections.rowCount());
        Long ret = (Long)criteria.uniqueResult();
        return ret;
    }

    public List getPageData(Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        return this.getPageData(false, returnType, filters, order, firstResult, maxResult);
    }

    public List getPageData(boolean cacheable, Class returnType, Map<String, Object> filters, Map<String, ESqlOrder> order, int firstResult, int maxResult) {
        Criteria criteria = this.currentSession().createCriteria(returnType);
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResult);
        criteria.setReadOnly(true);
        criteria.setCacheable(cacheable);
        if (filters != null) {
            Iterator var8 = filters.entrySet().iterator();

            while(var8.hasNext()) {
                Map.Entry entry = (Map.Entry)var8.next();
                criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
            }
        }

        if (!CollectionUtils.isNullOrEmpty(order)) {
            order.forEach((k, v) -> {
                if (v == ESqlOrder.ASC) {
                    criteria.addOrder(Order.asc(k));
                } else if (v == ESqlOrder.DESC) {
                    criteria.addOrder(Order.desc(k));
                }

            });
        }

        List list = criteria.list();
        return list;
    }

    public String getLatestUpdateTime(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        if (filters != null) {
            Iterator var4 = filters.entrySet().iterator();

            while(var4.hasNext()) {
                Map.Entry entry = (Map.Entry)var4.next();
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)entry.getValue()));
                } else {
                    criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
                }
            }
        }

        criteria.setProjection(Projections.projectionList().add(Projections.max("lastModifyTime")));
        Date lastModifyTime = (Date)criteria.uniqueResult();
        return lastModifyTime == null ? "" : String.valueOf(lastModifyTime.getTime());
    }

    public Date getLatestUpdateDate(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        if (filters != null) {
            Iterator var4 = filters.entrySet().iterator();

            while(var4.hasNext()) {
                Map.Entry entry = (Map.Entry)var4.next();
                if (entry.getValue() instanceof Collection) {
                    criteria.add(Restrictions.in((String)entry.getKey(), (Collection)entry.getValue()));
                } else {
                    criteria.add(Restrictions.eq((String)entry.getKey(), entry.getValue()));
                }
            }
        }

        criteria.setProjection(Projections.projectionList().add(Projections.max("lastModifyTime")));
        return (Date)criteria.uniqueResult();
    }

    public String queryDBStamp(Class clazz, Map<String, Object> filters) {
        Criteria criteria = this.currentSession().createCriteria(clazz);
        criteria.setCacheable(false);
        criteria.setReadOnly(true);
        criteria.setProjection(Projections.projectionList().add(Projections.count("last_modify_time")).add(Projections.max("last_modify_time")));
        Object[] objList = (Object[])((Object[])criteria.uniqueResult());
        return objList == null ? "" : Joiner.on("@").useForNull("-").join(objList);
    }
}
