package common.session.model.ddo;

import com.valor.mfc.vms.common.database.model.AbstractLMI;

import javax.persistence.*;
import java.util.Date;

@MappedSuperclass
public class LoginSession extends AbstractLMI {
    @Id
    @Column(
            name = "account_type"
    )
    public Integer accountType;
    @Id
    @Column(
            name = "account_id"
    )
    public Long accountId;
    @Id
    @Column(name = "client_session",length = 128)
    public String clientSession;

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "login_time")
    protected Date loginTime;
    @Column(
            name = "client_ip",
            length = 128
    )
    protected String clientIp;
    @Column(
            name = "status"
    )
    // 0 offline, 1 inactive, 2 online
    protected Integer status;
    @Column(
            name = "did",
            length = 64
    )
    protected String did;
    @Column(
            name = "cpu_id",
            length = 128
    )
    protected String cpuId;
    @Column(
            name = "android_id",
            length = 128
    )
    protected String androidId;
    @Column(
            name = "imei_id",
            length = 128
    )
    protected String imeiId;
    @Column(
            name = "sub_account_name",
            length = 128
    )
    protected String subAccountName;


    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getClientSession() {
        return clientSession;
    }

    public void setClientSession(String clientSession) {
        this.clientSession = clientSession;
    }

    public Date getLoginTime() {
        return loginTime;
    }

    public void setLoginTime(Date loginTime) {
        this.loginTime = loginTime;
    }

    public String getClientIp() {
        return clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getDid() {
        return did;
    }

    public void setDid(String did) {
        this.did = did;
    }

    public String getCpuId() {
        return cpuId;
    }

    public void setCpuId(String cpuId) {
        this.cpuId = cpuId;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }

    public String getImeiId() {
        return imeiId;
    }

    public void setImeiId(String imeiId) {
        this.imeiId = imeiId;
    }

    public String getSubAccountName() {
        return subAccountName;
    }

    public void setSubAccountName(String subAccountName) {
        this.subAccountName = subAccountName;
    }
}
