package common.session.service;

import common.session.model.dto.ClientInfo;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;

import java.util.List;
import java.util.Map;

/**
 * create by charlie.song 2018/8/7
 */
public interface SessionService {

    /**
     * create session
     *
     * @param accountType      0 build-in user，1 register user
     * @param accountId        account id
     * @param limit            max same time online client
     * @param subAccountName   sub account name
     * @param returnClientInfo 1 return online client information list, 0 do not return online client information list
     * @param extParam         ext parameters must be include: did,client mac address may be include: cpuId, client cpu
     *                         id androidId, imeiId, clientIp, client ip address
     * @return client session info and error code, 0 success,1 other error, 2 same time online client limit if
     * errCode==0 return the current client's session info if errCode!=0 and returnClientInfo==true return all client's
     * session info of the accountId
     */
    public WebApiResponse<List<ClientInfo>> createSession(Integer accountType, Long accountId, Integer limit, String subAccountName, Boolean returnClientInfo, Map extParam);

    /**
     * offline session
     *
     * @param accountType         0 build-in user，1 register user
     * @param accountId           account id
     * @param targetClientSession to be offline client session digest
     * @param selfClientSession   current client session digest
     * @param extParam            ext parameters must be include: did,client mac address may be include: cpuId, client
     *                            cpu id androidId, imeiId, clientIp, client ip address
     * @return error code, 0 success,1 other error
     */
    public WebApiBaseResponse offlineSession(Integer accountType, Long accountId, String targetClientSession, String selfClientSession, Map extParam);

    /**
     * check session
     *
     * @param accountType   0 build-in user，1 register user
     * @param clientSession client session digest
     * @param accountId     account id
     * @param extParam      ext parameters must be include: did,client mac address may be include: cpuId, client cpu id
     *                      androidId, imeiId, clientIp, client ip address
     * @return error code, 0 success,1 other error, 2 fail
     */
    public WebApiBaseResponse checkSession(Integer accountType, Long accountId, String clientSession, Map extParam);


    /**
     * update sub account name
     *
     * @param accountType         0 build-in user，1 register user
     * @param accountId           account id
     * @param targetClientSession client session digest to be updated
     * @param subAccountName      sub account name
     * @return error code, 0 success,1 other error
     */
    public WebApiBaseResponse updateSubAccountName(Integer accountType, Long accountId, String targetClientSession, String subAccountName);
}
