/*
 * Decompiled with CFR 0.152.
 */
package common.session.configuration;

import com.google.common.base.Strings;
import com.valor.mfc.vms.common.database.tool.configruation.AbstractDBCfgWithHikariCP;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SessionDBConfiguration
extends AbstractDBCfgWithHikariCP {
    private static final Logger logger = LoggerFactory.getLogger(SessionDBConfiguration.class);
    public static final String DATABASE_MODEL_BASE_PACKAGE = "common.session";
    private static final String AES_KEY = "Ebw6MyVpHAC23ZMszboDDQ";
    private String host = ConfigAESTools.getAESString((String)"common.session.db.host", (String)"Ebw6MyVpHAC23ZMszboDDQ");
    private String inst = ConfigAESTools.getAESString((String)"common.session.db.inst", (String)"Ebw6MyVpHAC23ZMszboDDQ");
    private String user = ConfigAESTools.getAESString((String)"common.session.db.user", (String)"Ebw6MyVpHAC23ZMszboDDQ");
    private String pass = ConfigAESTools.getAESString((String)"common.session.db.pass", (String)"Ebw6MyVpHAC23ZMszboDDQ");
    private String appendPackagesToScan = ConfigTools3.getString((String)"common.session.db.appendPackagesToScan");

    private String getConnectUrl() {
        if (!(Strings.isNullOrEmpty((String)this.host) || Strings.isNullOrEmpty((String)this.inst) || Strings.isNullOrEmpty((String)this.user) || Strings.isNullOrEmpty((String)this.pass))) {
            return "jdbc:mysql://" + this.host + "/" + this.inst + "?useUnicode=true&characterEncoding=utf8&autoReconnect=true";
        }
        logger.error("{}-{}-{}-{}", new Object[]{this.host, this.inst, this.user, this.pass});
        throw new IllegalArgumentException("Invalid parameter");
    }

    @Bean(destroyMethod="close", name={"cscDataSource"})
    public DataSource cscDataSource() {
        logger.info("Connect database:{}-{}-{}", new Object[]{this.host, this.inst, this.user});
        return this.getDataSource(this.getConnectUrl(), this.user, this.pass);
    }

    @Bean(name={"cscSessionFactory"}, destroyMethod="destroy")
    @Qualifier(value="cscSessionFactory")
    public FactoryBean<SessionFactory> cscSessionFactory() {
        return this.getSessionFactory(this.cscDataSource(), DATABASE_MODEL_BASE_PACKAGE);
    }

    @Bean(name={"cscTransactionManager"})
    @Qualifier(value="cscTransactionManager")
    public PlatformTransactionManager cscTransactionManager() throws Exception {
        return this.getTransactionManager((SessionFactory)this.cscSessionFactory().getObject(), 1800);
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource cscDataSource, String ... scanPackages) {
        return super.getSessionFactory(cscDataSource, scanPackages);
    }

    public PlatformTransactionManager getTransactionManager(SessionFactory cscSessionFactory, int txTimeout) throws Exception {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(cscSessionFactory);
        transactionManager.setDefaultTimeout(txTimeout);
        return transactionManager;
    }

    public Properties getDBProperties() {
        Properties props = super.getDBProperties();
        this.useL2Cache = ConfigTools3.getBoolean((String)"common.session.db.useL2Cache", (boolean)false);
        logger.info("Use L2 Cache:[{}]", (Object)this.useL2Cache);
        props.put("hibernate.cache.use_second_level_cache", (Object)this.useL2Cache);
        if (this.useL2Cache) {
            props.put("hibernate.cache.region.factory_class", this.l2CacheFactory);
            props.put("hibernate.cache.use_query_cache", (Object)this.useQueryCache);
        }
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        return props;
    }
}

