/*
 * Decompiled with CFR 0.152.
 */
package common.session.service.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import common.base.tools.JSON.JSONTools;
import common.base.tools.encrypt.MD5Tools;
import common.config.tools.config.ConfigTools3;
import common.session.model.dao.SessionBaseDao;
import common.session.model.ddo.LoginSession;
import common.session.model.ddo.LoginSessionAccount;
import common.session.model.ddo.LoginSessionDevice;
import common.session.model.dto.ClientInfo;
import common.session.service.SessionService;
import common.web.tools.http.model.response.WebApiBaseResponse;
import common.web.tools.http.model.response.WebApiResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sessionService")
@Transactional(value="cscTransactionManager")
public class SessionServiceImpl
implements SessionService {
    private static final Logger logger = LoggerFactory.getLogger(SessionServiceImpl.class);
    @Autowired
    private SessionBaseDao sessionBaseDao;
    private LoadingCache<String, Integer> sessionStatusCache;

    private LoadingCache<String, Integer> getSessionStatusCache() {
        if (this.sessionStatusCache == null) {
            this.sessionStatusCache = CacheBuilder.newBuilder().maximumSize(ConfigTools3.getLong((String)"common.session.status.cache.size", (Long)10000L).longValue()).expireAfterWrite(ConfigTools3.getLong((String)"common.session.status.cache.expire", (Long)10L).longValue(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Integer>(){

                public Integer load(String key) throws Exception {
                    String[] k = key.split("_");
                    Class realClass = Integer.parseInt(k[0]) == 0 ? LoginSessionDevice.class : LoginSessionAccount.class;
                    LoginSession loginSession = (LoginSession)((Object)SessionServiceImpl.this.sessionBaseDao.getData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"accountId", (Object)Long.valueOf(k[1]), (Object)"clientSession", (Object)k[2])));
                    if (loginSession == null) {
                        return 0;
                    }
                    return loginSession.getStatus();
                }
            });
        }
        return this.sessionStatusCache;
    }

    @Override
    @Transactional(value="cscTransactionManager")
    public WebApiResponse<List<ClientInfo>> createSession(Integer accountType, Long accountId, Integer limit, String subAccountName, Boolean returnClientInfo, Map extParam) {
        WebApiResponse webApiResponse = new WebApiResponse();
        String args = String.format(" accountType=%s,accountId=%s,limit=%s,subAccountName=%s,returnClientInfo=%s", accountType, accountId, limit, subAccountName, returnClientInfo);
        try {
            args = args + ",extParam=" + extParam;
            logger.info("create session start: " + args);
            String did = (String)extParam.get("did");
            if (accountType == null || accountId == null || limit == null) {
                logger.info("create session: parameter error." + args);
                webApiResponse.setRetCode(1000);
                webApiResponse.setErrCode(1);
                webApiResponse.setMessage("parameter error");
                return webApiResponse;
            }
            String cpuId = (String)extParam.get("cpuId");
            String androidId = (String)extParam.get("androidId");
            String imeiId = (String)extParam.get("imeiId");
            String clientIp = (String)extParam.get("clientIp");
            logger.info("create session: check parameter ok." + args);
            String clientSession = MD5Tools.hmacMd5((String)(did + cpuId + androidId + imeiId));
            ArrayList<ClientInfo> clientInfoList = new ArrayList<ClientInfo>();
            Class realClass = accountType == 0 ? LoginSessionDevice.class : LoginSessionAccount.class;
            Integer status = ConfigTools3.getInt((String)"common.session.inactive.limit", (Integer)0) == 0 ? Integer.valueOf(2) : Lists.newArrayList((Object[])new Integer[]{1, 2});
            List onlineSessionList = this.sessionBaseDao.getListDataIn(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"status", (Object)status, (Object)"accountId", (Object)accountId));
            int otherClient = 0;
            LoginSession loginSession = null;
            if (onlineSessionList != null && !onlineSessionList.isEmpty()) {
                otherClient = onlineSessionList.size();
                for (LoginSession session : onlineSessionList) {
                    if (!session.getClientSession().equals(clientSession)) continue;
                    logger.info("create session: current client has online session." + args);
                    loginSession = session;
                    --otherClient;
                }
            }
            logger.info("create session: count other online client." + args + ",otherClient=" + otherClient);
            if (otherClient >= limit) {
                webApiResponse.setRetCode(1000);
                webApiResponse.setErrCode(2);
                webApiResponse.setMessage("online client number limit");
                if (returnClientInfo.booleanValue() && onlineSessionList != null) {
                    for (LoginSession session : onlineSessionList) {
                        if (session.getClientSession().equals(clientSession)) continue;
                        ClientInfo c = new ClientInfo();
                        c.setDuration((System.currentTimeMillis() - session.getLoginTime().getTime()) / 1000L);
                        c.setSubAccountName(session.getSubAccountName());
                        c.setDid(session.getDid());
                        c.setClientSession(session.getClientSession());
                        c.setClientIp(session.getClientIp());
                        c.setSelf(session.getClientSession().equals(clientSession));
                        c.setAccountType(accountType);
                        c.setAccountId(accountId);
                        clientInfoList.add(c);
                    }
                }
                webApiResponse.setResult(clientInfoList);
                logger.info("create session: beyond limit." + args);
                return webApiResponse;
            }
            if (loginSession == null) {
                logger.info("create session: check if has a old offline session." + args);
                loginSession = (LoginSession)((Object)this.sessionBaseDao.getData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"accountId", (Object)accountId, (Object)"clientSession", (Object)clientSession)));
            }
            Date now = new Date();
            if (loginSession == null) {
                logger.info("create session: create a new session." + args);
                loginSession = accountType == 0 ? new LoginSessionDevice() : new LoginSessionAccount();
                loginSession.setAccountType(accountType);
                loginSession.setAccountId(accountId);
                loginSession.setClientSession(clientSession);
                loginSession.setCreateTime(now);
                loginSession.setDid(did);
                loginSession.setCpuId(cpuId);
                loginSession.setAndroidId(androidId);
                loginSession.setImeiId(imeiId);
            }
            loginSession.setStatus(2);
            loginSession.setLoginTime(now);
            loginSession.setLastModifyTime(now);
            if (StringUtils.isNotBlank((CharSequence)subAccountName)) {
                loginSession.setSubAccountName(subAccountName);
            }
            if (StringUtils.isNotBlank((CharSequence)clientIp)) {
                loginSession.setClientIp(clientIp);
            }
            this.sessionBaseDao.storeEntity((Object)loginSession);
            if (ConfigTools3.getInt((String)"common.session.status.cache.enable", (Integer)0) == 1) {
                String cacheKey = accountType + "_" + accountId + "_" + clientSession;
                this.getSessionStatusCache().invalidate((Object)cacheKey);
            }
            logger.info("create session: prepare result." + args);
            webApiResponse.setRetCode(1000);
            webApiResponse.setErrCode(0);
            ClientInfo c = new ClientInfo();
            c.setDuration((System.currentTimeMillis() - loginSession.getLoginTime().getTime()) / 1000L);
            c.setSubAccountName(loginSession.getSubAccountName());
            c.setDid(loginSession.getDid());
            c.setClientSession(loginSession.getClientSession());
            c.setClientIp(loginSession.getClientIp());
            c.setAccountType(accountType);
            c.setAccountId(accountId);
            c.setSelf(true);
            clientInfoList.add(c);
            webApiResponse.setResult(clientInfoList);
            logger.info("create session finish:" + args);
            return webApiResponse;
        }
        catch (Exception e) {
            logger.error("create session error:" + args, (Throwable)e);
            webApiResponse.setRetCode(1000);
            webApiResponse.setErrCode(1);
            webApiResponse.setMessage("other error");
            return webApiResponse;
        }
    }

    @Override
    @Transactional(value="cscTransactionManager")
    public WebApiBaseResponse offlineSession(Integer accountType, Long accountId, String targetClientSession, String selfClientSession, Map extParam) {
        WebApiBaseResponse webApiBaseResponse = new WebApiBaseResponse();
        String args = String.format(" accountType=%s,accountId=%s,targetClientSession=%s,selfClientSession=%s,extParam=%s", accountType, accountId, targetClientSession, selfClientSession, extParam);
        try {
            logger.info("offline session start: " + args);
            if (accountType == null || accountId == null) {
                logger.info("offline session: parameter error." + args);
                webApiBaseResponse.setRetCode(1000);
                webApiBaseResponse.setErrCode(1);
                webApiBaseResponse.setMessage("parameter error");
                return webApiBaseResponse;
            }
            logger.info("offline session: check parameter ok." + args);
            Class realClass = accountType == 0 ? LoginSessionDevice.class : LoginSessionAccount.class;
            Date now = new Date();
            if (StringUtils.isNotBlank((CharSequence)targetClientSession)) {
                LoginSession loginSession = (LoginSession)((Object)this.sessionBaseDao.getData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"accountId", (Object)accountId, (Object)"clientSession", (Object)targetClientSession)));
                if (loginSession != null) {
                    if (loginSession.getStatus() != 0) {
                        loginSession.setStatus(0);
                        loginSession.setLastModifyTime(now);
                        this.sessionBaseDao.storeEntity((Object)loginSession);
                        if (ConfigTools3.getInt((String)"common.session.status.cache.enable", (Integer)0) == 1) {
                            String cacheKey = accountType + "_" + accountId + "_" + targetClientSession;
                            this.getSessionStatusCache().invalidate((Object)cacheKey);
                        }
                        logger.info("offline session: disable the client session of the parameter targetClientSession." + args);
                    } else {
                        logger.info("offline session: the client session is offline of the parameter targetClientSession." + args);
                    }
                } else {
                    logger.info("offline session: the client session of the parameter targetClientSession is not found." + args);
                }
            } else {
                List loginSessionList = this.sessionBaseDao.getListData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"status", (Object)2, (Object)"accountId", (Object)accountId));
                if (loginSessionList != null && !loginSessionList.isEmpty()) {
                    for (LoginSession session : loginSessionList) {
                        session.setLastModifyTime(now);
                        session.setStatus(0);
                    }
                    this.sessionBaseDao.storeAll(loginSessionList);
                    if (ConfigTools3.getInt((String)"common.session.status.cache.enable", (Integer)0) == 1) {
                        for (LoginSession session : loginSessionList) {
                            String cacheKey = accountType + "_" + accountId + "_" + session.getClientSession();
                            this.getSessionStatusCache().invalidate((Object)cacheKey);
                        }
                    }
                    logger.info("offline session: disable the client sessions of the parameter accountId." + args + ",loginSessionList=" + JSONTools.toJson((Object)loginSessionList));
                } else {
                    logger.info("offline session: online client sessions of the parameter accountId are not found." + args);
                }
            }
            logger.info("offline session finish:" + args);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(0);
            return webApiBaseResponse;
        }
        catch (Exception e) {
            logger.error("offline session error:" + args, (Throwable)e);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(1);
            webApiBaseResponse.setMessage("other error");
            return webApiBaseResponse;
        }
    }

    @Override
    public WebApiBaseResponse checkSession(Integer accountType, Long accountId, String clientSession, Map extParam) {
        WebApiBaseResponse webApiBaseResponse = new WebApiBaseResponse();
        String args = String.format(" accountType=%s,accountId=%s,clientSession=%s", accountType, accountId, clientSession);
        try {
            args = args + ",extParam=" + extParam;
            logger.debug("check session start: " + args);
            if (StringUtils.isBlank((CharSequence)clientSession) || accountType == null || accountId == null) {
                logger.info("check session: parameter error." + args);
                webApiBaseResponse.setRetCode(1000);
                webApiBaseResponse.setErrCode(1);
                webApiBaseResponse.setMessage("parameter error");
                return webApiBaseResponse;
            }
            logger.debug("check session: check parameter ok." + args);
            Integer status = 0;
            if (ConfigTools3.getInt((String)"common.session.status.cache.enable", (Integer)0) == 1) {
                String cacheKey = accountType + "_" + accountId + "_" + clientSession;
                status = (Integer)this.getSessionStatusCache().get((Object)cacheKey);
            } else {
                Class realClass = accountType == 0 ? LoginSessionDevice.class : LoginSessionAccount.class;
                LoginSession loginSession = (LoginSession)((Object)this.sessionBaseDao.getData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"accountId", (Object)accountId, (Object)"clientSession", (Object)clientSession)));
                if (loginSession != null) {
                    status = loginSession.getStatus();
                }
            }
            Boolean isOnline = ConfigTools3.getInt((String)"common.session.inactive.limit", (Integer)0) == 0 ? Boolean.valueOf(status == 2) : Boolean.valueOf(status == 2 || status == 1);
            if (!isOnline.booleanValue()) {
                logger.info("offline session: client session is not exists or offline." + args);
                webApiBaseResponse.setRetCode(1000);
                webApiBaseResponse.setErrCode(2);
                webApiBaseResponse.setMessage("offline");
                return webApiBaseResponse;
            }
            logger.debug("check session finish:" + args);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(0);
            return webApiBaseResponse;
        }
        catch (Exception e) {
            logger.error("check session error:" + args, (Throwable)e);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(1);
            webApiBaseResponse.setMessage("other error");
            return webApiBaseResponse;
        }
    }

    @Override
    public WebApiBaseResponse updateSubAccountName(Integer accountType, Long accountId, String targetClientSession, String subAccountName) {
        WebApiBaseResponse webApiBaseResponse = new WebApiBaseResponse();
        String args = String.format(" accountType=%s,accountId=%s,targetClientSession=%s,subAccountName=%s", accountType, accountId, targetClientSession, subAccountName);
        try {
            logger.info("update subAccountName start: " + args);
            if (accountType == null || accountId == null || StringUtils.isBlank((CharSequence)targetClientSession) || StringUtils.isBlank((CharSequence)subAccountName)) {
                logger.info("update subAccountName: parameter error." + args);
                webApiBaseResponse.setRetCode(1000);
                webApiBaseResponse.setErrCode(1);
                webApiBaseResponse.setMessage("parameter error");
                return webApiBaseResponse;
            }
            logger.info("update subAccountName: check parameter ok." + args);
            Class realClass = accountType == 0 ? LoginSessionDevice.class : LoginSessionAccount.class;
            Date now = new Date();
            LoginSession loginSession = (LoginSession)((Object)this.sessionBaseDao.getData(false, realClass, (Map<String, Object>)ImmutableMap.of((Object)"accountId", (Object)accountId, (Object)"clientSession", (Object)targetClientSession)));
            if (loginSession != null) {
                loginSession.setSubAccountName(subAccountName);
                loginSession.setLastModifyTime(now);
                this.sessionBaseDao.storeEntity((Object)loginSession);
                if (ConfigTools3.getInt((String)"common.session.status.cache.enable", (Integer)0) == 1) {
                    String cacheKey = accountType + "_" + accountId + "_" + targetClientSession;
                    this.getSessionStatusCache().invalidate((Object)cacheKey);
                }
                logger.info("update subAccountName: update subAccountName ok" + args);
            } else {
                logger.info("update subAccountName: the client session of the parameter targetClientSession is not found." + args);
            }
            logger.info("update subAccountName finish:" + args);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(0);
            return webApiBaseResponse;
        }
        catch (Exception e) {
            logger.error("update subAccountName error:" + args, (Throwable)e);
            webApiBaseResponse.setRetCode(1000);
            webApiBaseResponse.setErrCode(1);
            webApiBaseResponse.setMessage("other error");
            return webApiBaseResponse;
        }
    }
}

