package common.stcode;

import java.util.Arrays;

public class NumberStringifier {

    private final char[] digits;

    public NumberStringifier(char[] digits) {
        this.digits = Arrays.copyOf(digits, digits.length);
    }

    private int indexOf(char c) {
        for ( int i = 0; i < digits.length; i++ ) {
            if ( digits[i] == c ) {
                return i;
            }
        }
        return -1;
    }

    public String stringify(long number) {
        final int radix = digits.length;
        StringBuilder sb = new StringBuilder();
        long remaining = number;
        while ( remaining != 0 ) {
            int n = (int) (remaining % radix);
            sb.append(digits[n]);
            remaining = remaining / radix;
        }
        return sb.reverse().toString();
    }

    public long parse(String text) throws NumberFormatException {
        final int radix = digits.length;
        long result = 0L;
        for ( char c : text.toCharArray() ) {
            int i = indexOf(c);
            if ( i == -1 ) {
                throw new NumberFormatException("For input string \"" + text + "\"");
            }
            result = result * radix + i;
        }
        return result;
    }


}
