package common.stcode;

import com.google.common.base.Strings;


public class STCodeBuilder extends StCodeValidate {

    //factory id 0000~9999
    private int factoryId = 0;
    private int version = 3;

    private static final SnowFlakeID idGen = SnowFlakeID.getInstance(0);

    public STCodeBuilder(int factoryId, int version) {
        this.factoryId = factoryId;
        this.version = version;
    }

    private STCodeBuilder() {
    }

    public String nextCode() {
        long code = idGen.nextId();
        long checksum = calcChecksum(code,MAX_CHECK_CODE);

        String f = toStr(factoryId, 4);
        String v = toHexStr(version, 2);
        String s = toR62String(checksum, 2);
        String c = toR62String(code, 12);

        return String.format("%s%s%s%s", f, v, s, c);
    }


    private String toHexStr(long num, int maxLen) {
        return Strings.padStart(Long.toHexString(num).toUpperCase(), maxLen, '0');
    }

    private String toStr(long num, int maxLen) {
        return Strings.padStart(Long.toString(num), maxLen, '0');
    }
}
