package common.stcode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;

import java.util.Map;

import static common.stcode.StCodeValidate.validate;

public class STCodeDO {
    private long factory;
    private long version;
    private long checksum;
    private long code;

    private long machineId;
    private long sequence;

    private long timestamp;

    public STCodeDO(String code) {
        parseStCode(code);
    }

    /**
     * 解析 st code
     * @param code:ST code
     */
    public void parseStCode(String code) {
        Map<String, String> stCodeMap = Maps.newHashMap();
        if (validate(code) != 0) {
            return;
        }

        this.factory = Long.parseLong(code.substring(0, 4),16);
        this.version = Long.parseLong(code.substring(4, 6),16);
        this.checksum = Long.parseLong(code.substring(6, 8),16);
        this.code = Long.parseLong(code.substring(8),16);

        this.machineId = SnowFlakeID.parseMachineId(this.code);
        this.timestamp = SnowFlakeID.parseAbsTimestamp(this.code);
        this.sequence = SnowFlakeID.parseSequence(this.code);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("factory", factory)
                .add("version", version)
                .add("checksum", checksum)
                .add("code", code)
                .add("code.machineId", machineId)
                .add("code.sequence", sequence)
                .add("code.timestamp", timestamp)
                .toString();
    }
}
