/*
 * Decompiled with CFR 0.152.
 */
package common.stcode;

import java.util.Arrays;

public class NumberStringifier {
    private final char[] digits;

    public NumberStringifier(char[] digits) {
        this.digits = Arrays.copyOf(digits, digits.length);
    }

    private int indexOf(char c) {
        for (int i = 0; i < this.digits.length; ++i) {
            if (this.digits[i] != c) continue;
            return i;
        }
        return -1;
    }

    public String stringify(long number) {
        int radix = this.digits.length;
        StringBuilder sb = new StringBuilder();
        for (long remaining = number; remaining != 0L; remaining /= (long)radix) {
            int n = (int)(remaining % (long)radix);
            sb.append(this.digits[n]);
        }
        return sb.reverse().toString();
    }

    public long parse(String text) throws NumberFormatException {
        int radix = this.digits.length;
        long result = 0L;
        for (char c : text.toCharArray()) {
            int i = this.indexOf(c);
            if (i == -1) {
                throw new NumberFormatException("For input string \"" + text + "\"");
            }
            result = result * (long)radix + (long)i;
        }
        return result;
    }
}

