/*
 * Decompiled with CFR 0.152.
 */
package common.stcode;

import com.google.common.base.Strings;
import common.stcode.SnowFlakeID;
import common.stcode.StCodeValidate;

public class STCodeBuilder
extends StCodeValidate {
    private int factoryId = 0;
    private int version = 3;
    private static final SnowFlakeID idGen = SnowFlakeID.getInstance(0L);

    public STCodeBuilder(int factoryId, int version) {
        this.factoryId = factoryId;
        this.version = version;
    }

    private STCodeBuilder() {
    }

    public String nextCode() {
        long code = idGen.nextId();
        long checksum = STCodeBuilder.calcChecksum(code, 31L);
        String f = this.toStr(this.factoryId, 4);
        String v = this.toHexStr(this.version, 2);
        String s = STCodeBuilder.toR62String(checksum, 2);
        String c = STCodeBuilder.toR62String(code, 12);
        return String.format("%s%s%s%s", f, v, s, c);
    }

    private String toHexStr(long num, int maxLen) {
        return Strings.padStart((String)Long.toHexString(num).toUpperCase(), (int)maxLen, (char)'0');
    }

    private String toStr(long num, int maxLen) {
        return Strings.padStart((String)Long.toString(num), (int)maxLen, (char)'0');
    }
}

