/*
 * Decompiled with CFR 0.152.
 */
package common.stcode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import common.stcode.SnowFlakeID;
import common.stcode.StCodeValidate;
import java.util.HashMap;

public class STCodeDO {
    private long factory;
    private long version;
    private long checksum;
    private long code;
    private long machineId;
    private long sequence;
    private long timestamp;

    public STCodeDO(String code) {
        this.parseStCode(code);
    }

    public void parseStCode(String code) {
        HashMap stCodeMap = Maps.newHashMap();
        if (StCodeValidate.validate(code) != 0) {
            return;
        }
        this.factory = Long.parseLong(code.substring(0, 4), 16);
        this.version = Long.parseLong(code.substring(4, 6), 16);
        this.checksum = Long.parseLong(code.substring(6, 8), 16);
        this.code = Long.parseLong(code.substring(8), 16);
        this.machineId = SnowFlakeID.parseMachineId(this.code);
        this.timestamp = SnowFlakeID.parseAbsTimestamp(this.code);
        this.sequence = SnowFlakeID.parseSequence(this.code);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("factory", this.factory).add("version", this.version).add("checksum", this.checksum).add("code", this.code).add("code.machineId", this.machineId).add("code.sequence", this.sequence).add("code.timestamp", this.timestamp).toString();
    }
}

