/*
 * Decompiled with CFR 0.152.
 */
package common.stcode;

import com.google.common.base.Strings;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowFlakeID {
    private static final Logger logger = LoggerFactory.getLogger(SnowFlakeID.class);
    private static final long START_TIMESTAMP = 1685548800000L;
    private static final long MACHINE_BIT = 10L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long TIMESTAMP_BIT = 41L;
    private static final long MAX_MACHINE_NUM = 1023L;
    private static final long MAX_SEQUENCE = 4095L;
    private static final long MAX_TIMESTAMP = 0x1FFFFFFFFFFL;
    private static final long SEQUENCE_STEP_SIZE = 1024L;
    private long basicSequence = 0L;
    private static String hostname = "";
    private static final long MACHINE_LEFT = 53L;
    private static final long SEQUENCE_LEFT = 41L;
    private static final long TIMESTMP_LEFT = 0L;
    private long machineId = 1L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public static SnowFlakeID getInstance(long machineId) {
        UniqueIdGeneratorInstance.instance.setMachineId(machineId);
        return UniqueIdGeneratorInstance.instance;
    }

    private SnowFlakeID() {
    }

    private long setMachineId(long machineId) {
        if (machineId > 0L && machineId <= 1023L) {
            this.machineId = machineId;
            return this.machineId;
        }
        String machineStr = this.getMachineStr();
        this.machineId = Math.abs(machineStr.hashCode() % 1023);
        logger.info("common.stcode.SnowFlakeID:MachineId[{}] MachineStr[{}]", (Object)this.machineId, (Object)machineStr);
        return this.machineId;
    }

    private String getMachineStr() {
        int pid = SnowFlakeID.getCurrentPid();
        if (pid == -1) {
            pid = UUID.randomUUID().hashCode();
        }
        return SnowFlakeID.getHostname() + "@" + pid;
    }

    public synchronized long nextId() {
        long currentTimestamp = this.getNewTimestamp();
        if (currentTimestamp < this.lastTimestamp) {
            logger.warn("SnowFlakeID:Clock moved backwards.currentTimestamp:[{}],lastStamp[{}],Offset[{}]", new Object[]{currentTimestamp, this.lastTimestamp, currentTimestamp - this.lastTimestamp});
            this.basicSequence += 1024L;
            if (this.basicSequence > 4095L) {
                this.basicSequence = 0L;
                currentTimestamp = this.getNextMill();
            }
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.getNextMill();
            }
        } else {
            this.sequence = this.basicSequence;
        }
        this.lastTimestamp = currentTimestamp;
        return this.machineId << 53 | this.sequence << 41 | currentTimestamp - 1685548800000L;
    }

    public static long parseMachineId(long code) {
        return code >> 53 & 0x3FFL;
    }

    public static long parseSequence(long code) {
        return code >> 41 & 0xFFFL;
    }

    public static long parseTimestamp(long code) {
        return code & 0x1FFFFFFFFFFL;
    }

    public static long parseAbsTimestamp(long code) {
        return SnowFlakeID.parseTimestamp(code) + 1685548800000L;
    }

    private long getNextMill() {
        long mill = this.getNewTimestamp();
        while (mill <= this.lastTimestamp) {
            mill = this.getNewTimestamp();
        }
        return mill;
    }

    private long getNewTimestamp() {
        return System.currentTimeMillis();
    }

    public static final int getCurrentPid() {
        String pid;
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String processName = runtimeMXBean.getName();
        if (processName.indexOf(64) != -1 && !Strings.isNullOrEmpty((String)(pid = processName.substring(0, processName.indexOf(64))))) {
            return Integer.valueOf(pid);
        }
        return -1;
    }

    private static String getHostname() {
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            if (!Strings.isNullOrEmpty((String)hostname)) {
                return hostname;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostname = System.getenv("COMPUTERNAME");
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        hostname = System.getenv("HOSTNAME");
        if (!Strings.isNullOrEmpty((String)hostname)) {
            return hostname;
        }
        return null;
    }

    private static class UniqueIdGeneratorInstance {
        private static final SnowFlakeID instance = new SnowFlakeID();

        private UniqueIdGeneratorInstance() {
        }
    }
}

