/*
 * Decompiled with CFR 0.152.
 */
package common.stcode;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import common.stcode.NumberStringifier;
import java.util.List;

public class StCodeValidate {
    public static final List<Long> supportVersions = ImmutableList.of((Object)3L);
    public static final long MIN_FACTORY_ID = 1L;
    public static final long MAX_FACTORY_ID = 9999L;
    public static final long MAX_CHECK_CODE = 31L;
    private static final NumberStringifier r62 = new NumberStringifier("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray());

    public static int validate(String stCode) {
        long ver;
        if (Strings.isNullOrEmpty((String)stCode)) {
            return -1;
        }
        String pattern = "^[0-9A-Za-z]+$";
        if (!stCode.matches(pattern)) {
            return -2;
        }
        int len = stCode.length();
        if (len <= 6) {
            return -3;
        }
        String version = stCode.substring(4, 6);
        try {
            ver = Long.valueOf(version, 16);
        }
        catch (NumberFormatException ex) {
            return -4;
        }
        if (!supportVersions.contains(ver)) {
            return -4;
        }
        if (ver == 3L && len != 20) {
            return -5;
        }
        String factoryId = stCode.substring(0, 4);
        if (!StCodeValidate.validateFactoryId(factoryId, 1L, 9999L)) {
            return -6;
        }
        String checksumStrFromCode = stCode.substring(6, 8);
        String codeStr = stCode.substring(8);
        long checksumFromCode = r62.parse(checksumStrFromCode);
        long checksum = StCodeValidate.calcChecksum(r62.parse(codeStr), 31L);
        if (checksum != checksumFromCode) {
            return -7;
        }
        return 0;
    }

    protected static String toR62String(long num, int maxLength) {
        return Strings.padStart((String)r62.stringify(num), (int)maxLength, (char)'0');
    }

    private static boolean validateFactoryId(String factoryId, long min, long max) {
        int id = Integer.parseInt(factoryId, 16);
        return (long)id >= min && (long)id <= max;
    }

    public static long calcChecksum(long code, long maxCheckCode) {
        int i;
        String strOriginId = String.valueOf(code);
        int[] numbers = new int[strOriginId.length()];
        int length = strOriginId.length();
        for (i = 0; i < length; ++i) {
            numbers[i] = Character.getNumericValue(strOriginId.charAt(i));
        }
        for (i = numbers.length - 2; i >= 0; i -= 2) {
            int n = i;
            numbers[n] = numbers[n] << 1;
            numbers[i] = numbers[i] / 10 + numbers[i] % 10;
        }
        int validationCode = 0;
        for (int number : numbers) {
            validationCode += number;
        }
        return (long)(validationCode *= 9) % maxCheckCode;
    }
}

