package common.web.tools.diagnosis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.sys.SystemTools;
import common.web.tools.http.HttpTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;


@Controller
public class DiagnosisController {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisController.class);

    @ResponseBody
    @RequestMapping("/api/ping2")
    public Map<String, String> ping(HttpServletRequest httpRequest,
                                    HttpServletResponse httpResponse,
                                    @RequestParam(required = false, defaultValue = "0") int debug) {

        String clientIp = HttpTools.getRemoteHost(httpRequest);
        Map<String, String> response = Maps.newLinkedHashMap();
        response.put("server", SystemTools.getHostnameMD5());

        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));

        response.put("serverTimestamp", dateNow.getTime() + "");
        response.put("serverTime", simpleDateFormat.format(dateNow));
        response.put("clientIp", clientIp);


        if (debug == 1) {
            String builtVersion = ManifestTools.getInstance().getManifest("Built-Version");
            if (!Strings.isNullOrEmpty(builtVersion)) {
                response.put("Built-Version", builtVersion);
            }

            String buildBy = ManifestTools.getInstance().getManifest("Built-By");
            if (!Strings.isNullOrEmpty(buildBy)) {
                response.put("Built-By", buildBy);
            }

            String buildTime = ManifestTools.getInstance().getManifest("Built-Time");
            if (!Strings.isNullOrEmpty(buildTime)) {
                response.put("Built-Time", buildTime);
            }


            String buildJdk = ManifestTools.getInstance().getManifest("Built-Jdk");
            if (!Strings.isNullOrEmpty(buildJdk)) {
                response.put("Built-Jdk", buildJdk);
            }

            String springbootVersion = ManifestTools.getInstance().getManifest("Spring-Boot-Version");
            if (!Strings.isNullOrEmpty(springbootVersion)) {
                response.put("Built-Spring-Boot-Version", springbootVersion);
            }
        }

        return response;
    }
}
