package common.web.tools.webapi.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Created by Frank.Huang on 2017/1/19.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface WebApiAuthorizedIP {
    /**
     * Authorized ip list
     *
     * @return
     */
    String authIps() default "";

    /**
     * Authorized IP config name
     *
     * @return
     */
    String authIpCfgName() default "api.ip.auth";

    /**
     * @return
     */
    boolean useProxy() default false;

    /**
     * Proxy name:if client is end user, here should check the special header
     *
     * @return
     */
    String proxyName() default "X-PROXY";
}
