package common.web.tools.webapi.processor;


import comm.base.tools.api.exception.ApiException;
import common.base.tools.stat.StatTools;
import common.web.tools.http.HttpTools;
import common.web.tools.webapi.annotation.WebApiCall;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;


/**
 * Created by Frank.Huang on 2016/6/20.
 */
@Service
@Aspect
public class WebApiCallInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(WebApiCallInterceptor.class);


    @Pointcut(value = "@annotation(common.web.tools.webapi.annotation.WebApiCall)")
    public void webApiCall() {
    }

    @Around(value = "common.web.tools.webapi.processor.WebApiCallInterceptor.webApiCall()&&@annotation(wac)")
    public Object apiRun(ProceedingJoinPoint pjp, WebApiCall wac) throws ServletException, IOException, ApiException {
        String apiName = getApiName(pjp);
        String apiPath = getApiPath(pjp);

//        logRequest(pjp);
        StatTools.addReq(apiName);
        HttpServletRequest request = getRequest(pjp);
        HttpServletResponse response = getResponse(pjp);
        String host = HttpTools.getRemoteHost(request);

//        //更新参数
//        BaseRequestArgs baseArgs = getArgs(pjp);
//        if (baseArgs != null) {
//            baseArgs.setArgsFromParameter(request);
//            LogUtil.logArgs(baseArgs, host);
//        }

        try {
            if (wac.minVersion() > 0) {
                Long appVer = HttpTools.getLongParameter(request, "appVer");
                if (appVer == null || appVer < wac.minVersion()) {
                    throw new ApiException(-999999, "Unsupported version");
                }
            }

            StatTools.startTimer(apiName);
            Object retVal = pjp.proceed();
            StatTools.stopTimer(apiName);

//            //计算签名
//            HttpTools.updateSrvInfo(request, retVal);

//            if (isSuccess(retVal)) {
//                StatTools.addRsp(apiName);
//            } else {
//                //如果失败，修改http code为555
//                response.setStatus(555);
//                StatTools.addErr(apiName);
//            }

            //设置cache control 时间
            if (wac.cacheControl() > 0) {
                getResponse(pjp).setHeader("Cache-Control", "max-age=" + wac.cacheControl());
            }

//            logResponse(apiPath, retVal, wac);
            return retVal;
        } catch (Throwable throwable) {
            logger.error("API:[{}] Exception:[{}]", apiPath, throwable.toString());
            throw new ApiException(-999, "Internal error");
        }
    }

    public HttpServletRequest getRequest(JoinPoint jp) {
        return (HttpServletRequest) jp.getArgs()[0];
    }

    public HttpServletResponse getResponse(JoinPoint jp) {
        return (HttpServletResponse) jp.getArgs()[1];
    }

//    public BaseRequestArgs getArgs(JoinPoint jp) {
//        Object arg = null;
//        if (jp.getArgs().length >= 3) {
//            arg = jp.getArgs()[2];
//            if (arg instanceof BaseRequestArgs) {
//                return (BaseRequestArgs) arg;
//            }
//        }
//        return null;
//    }

    public String getApiName(JoinPoint jp) {
        String apiName = getRequest(jp).getRequestURI();
        apiName = apiName.substring(1).replace("/", "-");
        return apiName;
    }

    public String getApiPath(JoinPoint jp) {
        return getRequest(jp).getRequestURI();
    }

//    private void logRequest(JoinPoint jp) {
//        LogUtil.logReq(getRequest(jp));
//    }

//    private void logResponse(String apiName, Object result, WebApiCall webApiCall) {
//        if (result instanceof IResponse) {
//            int repLogLevel = webApiCall.logLevel();
//            if (repLogLevel == 1) {
//                LogUtil.logRsp((IResponse) result, apiName);
//            } else {
//                LogUtil.logRspSimple((IResponse) result, apiName);
//            }
//        } else if (result instanceof ResponseStatus) {
//            LogUtil.logRsp((ResponseStatus) result, apiName);
//        }
//    }
//
//    private boolean isSuccess(Object result) {
//        if (result instanceof ResponseStatus) {
//            return (((ResponseStatus) result).getRetCode() == 0);
//        }
//
//        return false;
//    }
}
