package common.web.tools.test;

import okhttp3.*;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HttpCallTool {
    
    public static String post(String host, String postData, int timeout) {
        OkHttpClient client = new OkHttpClient.Builder()
            .connectTimeout(timeout, TimeUnit.SECONDS)
            .readTimeout(timeout, TimeUnit.SECONDS)
            .writeTimeout(timeout, TimeUnit.SECONDS)
            .build();

        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, postData);
        Request request = new Request.Builder()
            .url(host)
            .post(body)
            .addHeader("content-type", "application/json")
            .addHeader("cache-control", "no-cache")
            .addHeader("postman-token", "cba33ecf-45e9-c58d-196c-cacb3f03a210")
            .build();

        try {
            System.out.println("----------------------Request----------------------");
            System.out.println(postData);
            System.out.println("----------------------Request----------------------");

            Response response = client.newCall(request).execute();
            System.out.println(response.code() + " : " + host);
            if (response.isSuccessful()) {
                return response.body().string();
            } else {
                return "";
            }

        } catch (IOException e) {
            e.printStackTrace();
        }

        return "555";
    }
}
