package common.web.tools.diagnosis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import common.base.tools.sys.SystemTools;
import common.web.tools.http.HttpTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;


@Controller
public class DiagnosisController {
    private static final Logger logger = LoggerFactory.getLogger(DiagnosisController.class);

    @Autowired
    private BuildProperties buildProperties;

    @ResponseBody
    @RequestMapping("/api/ping2")
    public Map<String, String> ping(HttpServletRequest httpRequest,
                                    HttpServletResponse httpResponse,
                                    @RequestParam(required = false, defaultValue = "0") int debug) {

        String clientIp = HttpTools.getRemoteHost(httpRequest);
        Map<String, String> response = Maps.newLinkedHashMap();
        response.put("server", SystemTools.getHostnameMD5());

        Date dateNow = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));

        response.put("serverTimestamp", dateNow.getTime() + "");
        response.put("serverTime", simpleDateFormat.format(dateNow));
        response.put("clientIp", clientIp);

        return response;
    }

    /**
     * Return version info
     * @param httpRequest
     * @param httpResponse
     * @return
     */
    @ResponseBody
    @RequestMapping(value = "/api/version/v1")
    public Map<String, String> versionV1(HttpServletRequest httpRequest,
                                         HttpServletResponse httpResponse) {
        Map<String, String> versionMap = Maps.newLinkedHashMap();
        versionMap.put("version", "UNKNOWN VERSION");
        if (buildProperties != null) {
            buildProperties.forEach(e -> {
                if (!Strings.isNullOrEmpty(e.getKey())) {
                    versionMap.put(e.getKey(), e.getValue());
                }
            });
        }
        return versionMap;
    }
}
