package common.web.tools.filter.crypt.v2;

import com.google.common.collect.Maps;
import comm.base.tools.api.exception.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.Objects;

/**
 * @Author: Frank.Huang
 * @Date: 2019-06-05
 * @Version: 1.0.0
 */
public class CryptFactory {
    private static final Logger logger = LoggerFactory.getLogger(CryptFactory.class);
    private static Map<String, ICryptProvider> providerMap = Maps.newHashMap();

    /**
     * Register crypt provider
     *
     * @param providers
     */
    public static void regProvider(ICryptProvider... providers) {
        for (ICryptProvider provider : providers) {
            if (Objects.nonNull(provider)) {
                providerMap.put(provider.getProtocol(), provider);
                logger.info("CryptFactory:regCryptProvider[{}]", provider.getProtocol());
            }
        }
    }

    /**
     * Get crypt provider
     *
     * @param protocol
     * @return
     */
    public static ICryptProvider getProvider(String protocol) throws ApiException {
        ICryptProvider provider = providerMap.get(protocol);
        if (Objects.isNull(provider)) {
            logger.error("CryptFactory protocol[{}] NOT config provider", protocol);
            throw new ApiException(-9991, String.format("Protocol[%s] NOT config", protocol));
        }

        return provider;
    }
}
