package common.web.tools.errormsg;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import common.base.tools.encrypt.Base62Tools;
import common.base.tools.type.LangTools;
import common.config.tools.config.ConfigTools3;

public class ErrMsgBuilder {

    public static String getSeparatorChar() {
        return ".";
    }

    public static String encodeUserAlias(String userAlias) {
        return Base62Tools.longToBase62(userAlias);
    }


    @Deprecated
    public static String getErrMsgKey(String lang, int ret, int errCode) {
        String language = LangTools.getOrDefaultLanguage(Strings.nullToEmpty(lang).toLowerCase());
        return Joiner.on(".").join(language, ret, errCode);
    }

    public static String getErrMsgKey(String appId, String lang, int errCode) {
        String language = LangTools.getOrDefaultLanguage(Strings.nullToEmpty(lang).toLowerCase());
        return Joiner.on(".").skipNulls().join(appId, language, errCode);
    }

    public static String getErrMsgKey(String lang, int errCode) {
        return getErrMsgKey(null, lang, errCode);
    }


    @Deprecated
    public static String getErrMsgDesc(String lang, int ret, int errCode, String defaultMsg) {
        String msg = ConfigTools3.getString(getErrMsgKey(lang, ret, errCode), defaultMsg);
        if (Strings.isNullOrEmpty(msg) && !LangTools.isEnglish(lang)) {
            msg = ConfigTools3.getString(getErrMsgKey(LangTools.LANG_EN, ret, errCode), defaultMsg);
        }

        return msg;
    }


    public static String getErrMsgDesc(String appId, String lang, int errCode, String defaultMsg) {
        String msg = ConfigTools3.getString(getErrMsgKey(appId, lang, errCode));
        if (Strings.isNullOrEmpty(msg)) {
            if (!LangTools.isEnglish(lang)) {
                msg = ConfigTools3.getString(getErrMsgKey(appId, LangTools.LANG_EN, errCode));
                if (Strings.isNullOrEmpty(msg)) {
                    msg = ConfigTools3.getString(getErrMsgKey("", lang, errCode));
                }

                if (Strings.isNullOrEmpty(msg)) {
                    msg = ConfigTools3.getString(getErrMsgKey("", LangTools.LANG_EN, errCode));
                }
            } else {
                msg = ConfigTools3.getString(getErrMsgKey("", lang, errCode));
            }
        }

        if (Strings.isNullOrEmpty(msg)) {
            return defaultMsg;
        } else {
            return msg;
        }
    }

    public static String getErrMsgDesc(String lang, int errCode, String defaultMsg) {
        return getErrMsgDesc(null, errCode, defaultMsg);
    }


    public static String fmtErrMsg(String userAlias, int errCode, String msg, String reason) {
        String errCodeTS = Base62Tools.longToBase62(System.currentTimeMillis() / 1000);
        String errCodeId = Joiner.on(getSeparatorChar()).join(encodeUserAlias(userAlias), errCodeTS, errCode);
        String errMsg = "NA";
        if (!Strings.isNullOrEmpty(msg)) {
            errMsg = msg;
        }

        if (!Strings.isNullOrEmpty(reason)) {
            errMsg = String.format("%s(%s)", errMsg, reason);
        }

        return errCodeId + ":" + errMsg;
    }

    public static String getErrMsg(
        String appId,
        String lang,
        int errCode,
        String userAlias,
        String defaultMsg,
        String reason) {
        String msg = getErrMsgDesc(appId, lang, errCode, defaultMsg);
        return fmtErrMsg(userAlias, errCode, msg, reason);
    }


    public static String getErrMsg(String appId,
        String lang,
        int errCode,
        String userAlias,
        String defaultMsg) {
        return getErrMsg(appId, lang, errCode, userAlias, defaultMsg, "");
    }

    public static String getErrMsg(String appId,
        String lang,
        int errCode,
        String userAlias) {
        return getErrMsg(appId, lang, errCode, userAlias, "");
    }

}
