/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.http;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import common.base.tools.type.NumberTools;
import javax.servlet.http.HttpServletRequest;

public class HttpTools {
    private static ImmutableList<String> ipHeaderNameList = ImmutableList.builder().add((Object)"x-forwarded-for").add((Object)"CF-Connecting-IP").add((Object)"Proxy-Client-IP").add((Object)"WL-Proxy-Client-IP").add((Object)"X-Forwarded-For").add((Object)"HTTP_X_REAL_IP").add((Object)"HTTP_CLIENT_IP").add((Object)"HTTP_X_FORWARDED_FOR").build();

    private static boolean isInvalidClientIp(String clientIp) {
        if (Strings.isNullOrEmpty((String)clientIp)) {
            return false;
        }
        return !"unknown".equalsIgnoreCase(clientIp);
    }

    public static String getRemoteHost(HttpServletRequest request) {
        String headerName;
        String remoteHost = null;
        UnmodifiableIterator unmodifiableIterator = ipHeaderNameList.iterator();
        while (unmodifiableIterator.hasNext() && !HttpTools.isInvalidClientIp(remoteHost = request.getHeader(headerName = (String)unmodifiableIterator.next()))) {
        }
        if (!HttpTools.isInvalidClientIp(remoteHost)) {
            remoteHost = request.getRemoteAddr();
        }
        if (!Strings.isNullOrEmpty(remoteHost) && remoteHost.length() > 15 && remoteHost.indexOf(",") > 0) {
            remoteHost = remoteHost.substring(0, remoteHost.indexOf(","));
        }
        return Strings.nullToEmpty((String)remoteHost);
    }

    public static String getHttpParameter(HttpServletRequest request, String key) {
        if (request == null) {
            return "";
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return "";
        }
        return request.getParameter(key);
    }

    public static Long getLongParameter(HttpServletRequest request, String key) {
        String v = HttpTools.getHttpParameter(request, key);
        if (Strings.isNullOrEmpty((String)v)) {
            return null;
        }
        return Long.valueOf(v);
    }

    public static Long getLongAttr(HttpServletRequest request, String key) {
        return HttpTools.getLongAttr(request, key, null);
    }

    public static Long getLongAttr(HttpServletRequest request, String key, Long defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            if (Strings.isNullOrEmpty((String)((String)v))) {
                return defaultValue;
            }
            return Long.valueOf((String)v);
        }
        return defaultValue;
    }

    public static int getIntAttr(HttpServletRequest request, String key, int defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            return NumberTools.str2int((String)((String)v));
        }
        return defaultValue;
    }

    public static String getAttr(HttpServletRequest request, String key, String defaultValue) {
        Object v = request.getAttribute(key);
        if (v == null) {
            return defaultValue;
        }
        return (String)v;
    }

    public static void setAttrIfAbsent(HttpServletRequest request, String key, Object value) {
        Object v = request.getAttribute(key);
        if (v == null) {
            request.setAttribute(key, value);
        }
    }

    public static void setAttr(HttpServletRequest request, String key, Object value) {
        request.setAttribute(key, value);
    }

    public static String getApiPath(HttpServletRequest request) {
        return request.getRequestURI();
    }

    public static String getRequestURI(HttpServletRequest request) {
        String apiName = request.getRequestURI();
        apiName = apiName.substring(1).replace("/", "_");
        return apiName;
    }

    public static String getClientRegion(HttpServletRequest request) {
        return Strings.nullToEmpty((String)request.getHeader("CF-IPCountry"));
    }
}

