/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.statistics.scheduler;

import com.google.common.collect.ImmutableMap;
import common.base.tools.statistics.MetricTools2;
import common.base.tools.statistics.StatQpsItem;
import common.base.tools.statistics.StatTimeItem;
import common.base.tools.sys.SystemTools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.statistics.scheduler.WebApiStatisticsScheduler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApiStatisticsReportTools {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsScheduler.class);

    public static void reportSlowRequest(String key, long time) {
        long slowMin = ConfigTools3.getLong((String)"statistics.slow", (Long)200000L);
        if (slowMin == 0L || time < slowMin) {
            return;
        }
        logger.info("[SLOW]name:[{}] time[{}]", (Object)key, (Object)time);
        String metricName = String.format("%s_time_slow", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"time", (Object)time);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportCount(String key, long count) {
        String metricName = String.format("%s_count", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportTimeConsumed(String key, long count, long avg) {
        String metricName = String.format("%s_time_consumed", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count, (Object)"avg", (Object)avg);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportTimeConsumedByStatus(String key, StatTimeItem timeItem) {
        int level = ConfigTools3.getInt((String)String.format("statistics.level.%s", key), (Integer)0);
        if (level <= 0) {
            return;
        }
        long count = timeItem.getCountGELevel(level);
        if (count == 0L) {
            return;
        }
        String reportKey = String.format("%s.%s", timeItem.getKey(), key);
        String metricName = String.format("%s_time_status", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)reportKey);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportQps(StatQpsItem item) {
        String metricName = String.format("%s_api_qps", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"apiName", (Object)item.getApiName(), (Object)"local", (Object)item.getLocalKey(), (Object)"server", (Object)item.getServerKey(), (Object)"status", (Object)item.getStatus());
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)item.getCount(), (Object)"maxQps", (Object)(1000.0 / (double)item.getMinDurationMs()), (Object)"minQps", (Object)(1000.0 / (double)item.getMaxDurationMs()), (Object)"avgQps", (Object)(1000.0 / item.getAvgDurationMs()));
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }
}

