package common.web.tools.filter.common;

import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ServletInputStreamWrapper extends ServletInputStream {
    private ByteArrayInputStream buffer;

    public ServletInputStreamWrapper(byte[] contents) {
        this.buffer = new ByteArrayInputStream(contents);
    }

    @Override
    public boolean isFinished() {
        return (buffer.available() == 0);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setReadListener(ReadListener readListener) {

    }

    @Override
    public int read() throws IOException {
        return buffer.read();
    }
}
