/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import common.config.tools.config.ConfigTools3;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResponseCacheTool {
    private static final Logger logger = LogManager.getLogger(ResponseCacheTool.class);
    private static final Cache<String, String> cache = CacheBuilder.newBuilder().maximumSize(ConfigTools3.getLong((String)"tve.response.cache.max.size", (Long)200000L).longValue()).expireAfterAccess(ConfigTools3.getLong((String)"tve.response.cache.expire.after.access.seconds", (Long)720L).longValue(), TimeUnit.SECONDS).removalListener(notification -> logger.info("[ResponseCache-Remove]:Expired and Removed:{}-{}", notification.getKey(), notification.getValue())).build();
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public static String get(String key) {
        return (String)cache.getIfPresent((Object)key);
    }

    public static void asyncPut(String key, Callable<String> callable) {
        executorService.submit(() -> {
            try {
                String value = (String)callable.call();
                cache.put((Object)key, (Object)value);
            }
            catch (Exception e2) {
                logger.error("[ResponseCache-Put] Error", (Throwable)e2);
            }
        });
    }

    public static void put(String key, String value) {
        if (ConfigTools3.getBoolean((String)"tve.channel.cache.enabled", (boolean)true)) {
            cache.put((Object)key, (Object)value);
        }
    }
}

