/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.crypt.filter;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.base.tools.statistics.ApiQpsStatisticsTools;
import common.base.tools.sys.SystemTools;
import common.config.tools.config.ConfigTools3;
import common.web.tools.filter.common.WebResponseWrapper;
import common.web.tools.filter.crypt.CryptACL;
import common.web.tools.filter.crypt.CryptMsgTools;
import common.web.tools.filter.crypt.ResponseCacheTool;
import common.web.tools.filter.crypt.model.ApiCryptMsg;
import common.web.tools.filter.crypt.model.ApiCryptMsg4Live;
import common.web.tools.http.HttpTools;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponseCryptFilter
extends OncePerRequestFilter {
    private static final Logger logger = LoggerFactory.getLogger(ResponseCryptFilter.class);
    private Gson gson = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Long requestArrivalTime = null;
        Map responseMap = new ConcurrentHashMap();
        Object obj = request.getAttribute("RequestArrivalTime");
        try {
            requestArrivalTime = (Long)obj;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            long clientTime;
            boolean isGetServerTime;
            String v = request.getParameter("v");
            if (Strings.isNullOrEmpty((String)v)) {
                v = request.getParameter("prot");
            }
            if (isGetServerTime = BooleanUtils.toBoolean((String)request.getHeader("GetServerTime"))) {
                response.addHeader("ServerTimeMS", Long.toString(System.currentTimeMillis()));
            }
            if ((clientTime = NumberUtils.toLong((String)request.getHeader("ClientTimeMS"), (long)0L)) > 0L) {
                response.addHeader("ClientTimeMS", Long.toString(clientTime));
            }
            String url = HttpTools.getRequestURI(request);
            if (Strings.isNullOrEmpty((String)v) || CryptACL.isResponseCryptDisable(url)) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                ServletOutputStream out = response.getOutputStream();
                WebResponseWrapper wrapper = new WebResponseWrapper(response);
                filterChain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
                if (CryptACL.isContentTypeCrypt(wrapper.getContentType())) {
                    responseMap = (Map)this.gson.fromJson(new String(wrapper.getData()), Map.class);
                    out.write(wrapper.getData());
                } else {
                    byte[] data = this.getData(wrapper, request, response, isGetServerTime, url, v);
                    if (Objects.nonNull(data)) {
                        responseMap = (Map)this.gson.fromJson(new String(data), Map.class);
                    }
                    String cryptMsg = this.encryptMsg(url, v, data);
                    data = cryptMsg.getBytes("utf-8");
                    out.write(data);
                }
            }
        }
        finally {
            if (requestArrivalTime != null && ConfigTools3.getBoolean((String)"statistics.qps.report", (boolean)false)) {
                String apiName = request.getRequestURI();
                String serverAddress = request.getLocalAddr();
                String serverPort = String.valueOf(request.getLocalPort());
                String httpResponseCode = String.valueOf(response.getStatus());
                int errCode = (Integer)responseMap.get("errCode");
                String errMsg = String.valueOf(responseMap.get("errMsg"));
                long duration = System.currentTimeMillis() - requestArrivalTime;
                ApiQpsStatisticsTools.statisticRequests((String)apiName, (String)serverAddress, (String)serverPort, (String)httpResponseCode, (int)errCode, (String)errMsg, (long)duration);
            }
        }
    }

    public void destroy() {
    }

    private byte[] getData(WebResponseWrapper wrapper, HttpServletRequest request, HttpServletResponse response, boolean isGetServerTime, String url, String v) throws IOException {
        byte[] data;
        String key = this.getKey(request);
        String msg = this.getCache(request, key);
        if (isGetServerTime) {
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                data = msg.getBytes("utf-8");
            } else {
                data = wrapper.getData();
                if (StringUtils.isNotEmpty((CharSequence)key)) {
                    ResponseCacheTool.put(key, new String(data, "utf-8"));
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)msg)) {
            data = wrapper.getData();
            msg = new String(data, "utf-8");
            if (StringUtils.isNotEmpty((CharSequence)key)) {
                ResponseCacheTool.put(key, msg);
            }
        } else {
            msg = this.updateServerTime(request, msg);
            data = msg.getBytes();
        }
        return data;
    }

    private String getKey(HttpServletRequest request) {
        Object obj = request.getAttribute("CacheKey");
        return obj == null ? "" : obj.toString();
    }

    private String getCache(HttpServletRequest request, String key) {
        Object obj = request.getAttribute("UseCache");
        boolean isUseCache = obj != null && Boolean.parseBoolean(obj.toString());
        String msg = "";
        if (isUseCache && !StringUtils.isEmpty((CharSequence)key)) {
            msg = StringUtils.trimToEmpty((String)ResponseCacheTool.get(key));
        }
        return msg;
    }

    private String encryptMsg(String url, String v, byte[] data) throws IOException {
        String cryptMsg = "";
        cryptMsg = CryptMsgTools.isLiveMsg(v) ? this.getCryptMessage4Live(url, v, data) : this.getCryptMessage(url, v, data);
        return cryptMsg;
    }

    private String updateServerTime(HttpServletRequest request, String msg) {
        String serverTimeField;
        Object obj = request.getAttribute("serverTimeField");
        String string = serverTimeField = obj == null ? "" : obj.toString();
        if (StringUtils.isNotEmpty((CharSequence)serverTimeField)) {
            return this.updateServerTime(msg, serverTimeField);
        }
        return msg;
    }

    private String updateServerTime(String json, String filedName) {
        int pos = StringUtils.indexOf((CharSequence)json, (CharSequence)filedName);
        if (pos < 0) {
            return json;
        }
        StringBuilder builder = new StringBuilder();
        while (json.charAt(pos) != ':') {
            ++pos;
        }
        builder.append(json, 0, pos + 1);
        builder.append(System.currentTimeMillis());
        while (json.charAt(pos) != ',') {
            ++pos;
        }
        builder.append(json, pos, json.length());
        return builder.toString();
    }

    private String getCryptMessage(String url, String protocol, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        ApiCryptMsg msg = new ApiCryptMsg();
        msg.setH(SystemTools.getHostnameMD5());
        msg.setT(System.currentTimeMillis());
        if (cryptEnable && CryptMsgTools.isSupportCrypt(protocol)) {
            msg.setV(protocol);
            msg.setM(CryptMsgTools.encryptMsg(protocol, data));
        } else {
            msg.setV("0");
            msg.setM(new String(data, "UTF-8"));
        }
        msg.setS(CryptMsgTools.sign(protocol, msg.getM()));
        return this.gson.toJson((Object)msg);
    }

    private String getCryptMessage4Live(String url, String prot, byte[] data) throws IOException {
        boolean cryptEnable = CryptACL.isCryptEnable(url);
        ApiCryptMsg4Live msg = new ApiCryptMsg4Live();
        if (cryptEnable && CryptMsgTools.isSupportCrypt(prot)) {
            msg.setProt(prot);
            msg.setPayload(CryptMsgTools.encryptMsg(prot, data));
        } else {
            msg.setProt("0");
            msg.setPayload(new String(data, "UTF-8"));
        }
        msg.setSignature(CryptMsgTools.sign(prot, msg.getPayload()));
        return this.gson.toJson((Object)msg);
    }
}

