package common.web.tools.filter.crypt.v2;

import comm.base.tools.api.exception.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by Frank.Huang on 2017/5/16.
 */
public class CryptTools {
    private static final Logger logger = LoggerFactory.getLogger(CryptTools.class);

    public String decrypt(String protocol, String msg, String signature) throws ApiException {
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        if (!provider.isSupportCrypt()) {
            return msg;
        }

        if (provider.isSupportSignature()) {
            boolean isSignature = provider.checkSignature(msg, signature);
            if (!isSignature) {
                throw new ApiException(CryptRetCode.CRYPT_ERR_SIGNATURE_FAILED, "SIGNATURE_FAILED");
            }
        }

        return provider.decrypt(msg);
    }

    public String encrypt(String protocol, String msg) throws ApiException {
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        if (!provider.isSupportCrypt()) {
            return msg;
        }

        return provider.encrypt(msg);
    }

    public String signature(String protocol, String msg) throws ApiException {
        ICryptProvider provider = CryptFactory.getProvider(protocol);
        return provider.signature(msg);
    }
}