package common.web.tools.filter.crypt.v2;

/**
 * Interface from crypt2
 *
 * @Author: Frank.Huang
 * @Date: 2019-06-05
 * @Version: 1.0.0
 */
public interface ICryptProvider {
    /**
     * Get protocol
     *
     * @return
     */
    String getProtocol();

    /**
     * Get property
     *
     * @param key
     * @return
     */
    String getProperty(String key);

    /**
     * Support crypt or not
     *
     * @return
     */
    boolean isSupportCrypt();

    /**
     * Support check signature
     *
     * @return
     */
    boolean isSupportSignature();

    /**
     * Encrypt message
     *
     * @param message
     * @return
     */
    String encrypt(String message);

    /**
     * Decrypt message
     *
     * @param message
     * @return
     */
    String decrypt(String message);

    /**
     * Signature message
     *
     * @param message
     * @return
     */
    String signature(String message);

    /**
     * Check signature
     *
     * @param msg
     * @param signature
     * @return
     */
    boolean checkSignature(String msg, String signature);
}
