/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.statistics.scheduler;

import com.google.common.base.Strings;
import common.base.tools.stat.StatTools;
import common.base.tools.statistics.ApiQpsStatisticsTools;
import common.base.tools.statistics.ApiRequestInfo;
import common.base.tools.statistics.CountStatisticsTools2;
import common.base.tools.statistics.TimeStatisticsTools2;
import common.base.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import common.web.tools.statistics.scheduler.WebApiStatisticsReportTools;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class WebApiStatisticsScheduler {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsScheduler.class);
    static long lastReportTS = 0L;

    @Scheduled(fixedRate=3000L)
    public void statisticsScheduler() {
        long cycle = ConfigTools3.getLong((String)"api.statistics.cycle", (Long)60000L);
        if (System.currentTimeMillis() - lastReportTS > cycle) {
            this.reportAndPrint();
            lastReportTS = System.currentTimeMillis();
        }
    }

    @Scheduled(fixedDelay=60000L)
    public void localStatisticsScheduler() {
        String msg = StatTools.dumpMutilline((boolean)false);
        if (!Strings.isNullOrEmpty((String)msg)) {
            logger.info("LOCAL-STAT:{}", (Object)msg);
        }
    }

    public void reportAndPrint() {
        if (ConfigTools3.getBoolean((String)"statistics.out.log", (boolean)true)) {
            boolean printPretty = ConfigTools3.getBoolean((String)"statistics.out.pretty", (boolean)true);
            String countStats = CountStatisticsTools2.dump((boolean)printPretty);
            String timeStats = TimeStatisticsTools2.dump((boolean)printPretty);
            if (!Strings.isNullOrEmpty((String)countStats) || !Strings.isNullOrEmpty((String)timeStats)) {
                logger.info("CountStats:{} TimeStats:{}", (Object)countStats, (Object)timeStats);
            }
        }
        if (ConfigTools3.getBoolean((String)"statistics.report", (boolean)true)) {
            this.reportCount2Metric();
            this.reportTime2Metric();
        }
        if (ConfigTools3.getBoolean((String)"statistics.qps.report", (boolean)true)) {
            this.reportQpiQps2Metric();
        }
        CountStatisticsTools2.clear();
        TimeStatisticsTools2.clear();
    }

    private void reportTime2Metric() {
        Map countMap = TimeStatisticsTools2.getTimeStatMap();
        countMap.forEach((k, v) -> {
            WebApiStatisticsReportTools.reportTimeConsumed(v.getKey(), v.getCount(), v.avg());
            ConfigTools3.getAsList((String)"statistics.level").forEach(s -> WebApiStatisticsReportTools.reportTimeConsumedByStatus(s, v));
        });
    }

    private void reportCount2Metric() {
        Map countMap = CountStatisticsTools2.getCountData();
        countMap.forEach((k, v) -> v.forEach((k1, v1) -> WebApiStatisticsReportTools.reportCount(String.format("%s-%s", k, k1), v1)));
    }

    private void reportQpiQps2Metric() {
        Map visit;
        List requests = ApiQpsStatisticsTools.getRequestSummary();
        if (!CollectionUtils.isNullOrEmpty((Collection)requests)) {
            for (ApiRequestInfo request : requests) {
                ApiQpsStatisticsTools.addVisits((ApiRequestInfo)request);
            }
        }
        if (!CollectionUtils.isNullOrEmpty((Map)(visit = ApiQpsStatisticsTools.getAndResetVisit()))) {
            for (Map.Entry element : visit.entrySet()) {
                WebApiStatisticsReportTools.reportQps(element);
            }
        }
    }
}

