package common.web.tools.http.restClient;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.util.concurrent.ListenableFutureCallback;

public abstract class RestCallAsyncCallback<RSP> implements ListenableFutureCallback<ResponseEntity<RSP>> {
    private static Logger logger = LoggerFactory.getLogger(RestCallAsyncCallback.class);

    @Override
    public void onSuccess(ResponseEntity<RSP> result) {
        logger.info("RestCallAsync:{}", result);
    }

    @Override
    public void onFailure(Throwable ex) {
        logger.error("RestCallAsync exception", ex);
    }
}
