/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.filter.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class WebResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private int contentLength;
    private String contentType;

    public WebResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public byte[] getData() {
        return this.output.toByteArray();
    }

    public ServletOutputStream getOutputStream() {
        return new FilterServletOutputStream(this.output);
    }

    public PrintWriter getWriter() {
        return new PrintWriter((OutputStream)this.getOutputStream(), true);
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }

    class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;
        private WriteListener writeListener;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return Boolean.TRUE;
        }

        public void setWriteListener(WriteListener wl) {
            this.writeListener = wl;
        }

        public WriteListener getWriteListener() {
            return this.writeListener;
        }
    }
}

