/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.statistics.influxdb;

import org.influxdb.annotation.Column;
import org.influxdb.annotation.Measurement;

@Measurement(name="qps_info")
public class QpsInfo {
    @Column(name="time")
    private long time;
    @Column(name="api_name", tag=true)
    private String apiName;
    @Column(name="server_address", tag=true)
    private String serverAddress;
    @Column(name="server_port")
    private String serverPort;
    @Column(name="http_response_code", tag=true)
    private String httpResponseCode;
    @Column(name="err_code", tag=true)
    private String errCode;
    @Column(name="err_msg")
    private String errMsg;
    @Column(name="visit_count")
    private int visitCount;
    @Column(name="max_qps")
    private double maxQps;
    @Column(name="min_qps")
    private double minQps;
    @Column(name="real_qps")
    private double realQps;

    public long getTime() {
        return this.time;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public String getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getVisitCount() {
        return this.visitCount;
    }

    public double getMaxQps() {
        return this.maxQps;
    }

    public double getMinQps() {
        return this.minQps;
    }

    public double getRealQps() {
        return this.realQps;
    }

    public QpsInfo(Builder builder) {
        this.time = builder.time;
        this.apiName = builder.apiName;
        this.serverAddress = builder.serverAddress;
        this.serverPort = builder.serverPort;
        this.httpResponseCode = builder.httpResponseCode;
        this.errCode = builder.errCode;
        this.errMsg = builder.errMsg;
        this.visitCount = builder.visitCount;
        this.maxQps = builder.maxQps;
        this.minQps = builder.minQps;
        this.realQps = builder.realQps;
    }

    public static class Builder {
        private long time;
        private String apiName;
        private String serverAddress;
        private String serverPort;
        private String httpResponseCode;
        private String errCode;
        private String errMsg;
        private int visitCount;
        private double maxQps;
        private double minQps;
        private double realQps;

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder serverAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder serverPort(String serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder httpResponseCode(String httpResponseCode) {
            this.httpResponseCode = httpResponseCode;
            return this;
        }

        public Builder errCode(String errCode) {
            this.errCode = errCode;
            return this;
        }

        public Builder errMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public Builder visitCount(int visitCount) {
            this.visitCount = visitCount;
            return this;
        }

        public Builder maxQps(double maxQps) {
            this.maxQps = maxQps;
            return this;
        }

        public Builder minQps(double minQps) {
            this.minQps = minQps;
            return this;
        }

        public Builder realQps(double realQps) {
            this.realQps = realQps;
            return this;
        }

        public QpsInfo build() {
            return new QpsInfo(this);
        }
    }
}

