package common.web.tools.servicetoken;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Service token v2 tools for factory create,check st
 */
public class ServiceToken4FactoryV2 {
    private static final Logger logger = LoggerFactory.getLogger(ServiceToken4FactoryV2.class);

    /**
     * ST (service token) is a token used to verify that the equipment is legal or not.
     * ST format:
     * ST list = ST(16 char) for tve | ST(16 char) mfc for mfc
     * ST = MD5(Upper(MAC)+ACTIVE CODE).substring(8,24)
     * <p>
     * Take the middle 16 bits as st
     */


    public static String buildSTV2(String mac, String activeCode) {
        String stStr = mac.toUpperCase() + activeCode;
        String md5 = Hashing.md5().hashString(stStr, Charsets.UTF_8).toString().toLowerCase();
        return md5.substring(8, 24);
    }

    public static String getSTByService(EService service, String st) {
        if (Strings.isNullOrEmpty(st)) {
            logger.warn("ST is empty!");
            return "";
        }

        if (st.length() != 32) {
            logger.warn("ST[{}] Wrong length", st);
            return "";
        }

        if (service == EService.TVE) {
            return st.substring(0, 16);
        } else {
            return st.substring(16, 32);
        }
    }

    public static String checkST(EService service, String st, String mac, String activeCode) {
        String st4Service = getSTByService(service, st);
        if (Strings.isNullOrEmpty(st4Service)) {
            logger.error("ST[{}] Service[{}] mac[{}] activeCode[{}] Cannot found Service ST", st, service, mac, activeCode);
            return "";
        }

        String original = buildSTV2(mac, activeCode);
        if (original.contentEquals(st4Service)) {
            return st4Service;
        } else {
            logger.error("ST[{}] Service[{}] mac[{}] activeCode[{}] ST check failed", st, service, mac, activeCode);
            return "";
        }
    }
}
