package common.web.tools.exception.handler;

import comm.base.tools.api.exception.ApiException;
import comm.base.tools.api.model.ApiBaseResponse;
import common.web.tools.http.model.response.WebApiBaseResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/**
 * Created by Frank.Huang on 2017/1/17.
 */
@ControllerAdvice
public class ApiExceptionHandler {

    @ResponseBody
    @ExceptionHandler(value = ApiException.class)
    public ApiBaseResponse apiException(HttpServletRequest httpRequest,
                                        HttpServletResponse httpResponse,
                                        ApiException apiException){


        httpResponse.setStatus(555);
        ApiBaseResponse response = new ApiBaseResponse();
        response.setErrCode(apiException.getErrCode());
        response.setMessage(apiException.getMessage());
        
        return response;
    }

}
