package common.web.tools.filter.crypt;

import com.google.common.cache.*;
import common.config.tools.config.ConfigTools3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ResponseCacheTool {
    private static final Logger logger = LogManager.getLogger(ResponseCacheTool.class);

    private static final Cache<String, String> cache = CacheBuilder.newBuilder()
            .maximumSize(ConfigTools3.getLong("tve.response.cache.max.size",200000L))
            .expireAfterAccess(ConfigTools3.getLong("tve.response.cache.expire.after.access.seconds", 720L), TimeUnit.SECONDS)
            .removalListener((RemovalListener<String, String>) notification -> logger.info(
                    "[ResponseCache-Remove]:Expired and Removed:{}-{}",
                    notification.getKey(), notification.getValue()))
            .build();

    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);

    public static String get(String key) {
        return cache.getIfPresent(key);
    }

    public static void asyncPut(String key, Callable<String> callable) {
        executorService.submit(() -> {
            try {
                String value = callable.call();
                cache.put(key, value);
            } catch (Exception e) {
                logger.error("[ResponseCache-Put] Error", e);
            }
        });
    }

    public static void put(String key, String value) {
        if (ConfigTools3.getBoolean("tve.channel.cache.enabled", true))
            cache.put(key, value);
    }
}
