/*
 * Decompiled with CFR 0.152.
 */
package common.web.tools.statistics.scheduler;

import com.google.common.collect.ImmutableMap;
import common.base.tools.statistics.MetricTools2;
import common.base.tools.statistics.QpsItem;
import common.base.tools.statistics.ServiceStatisticItem;
import common.base.tools.statistics.StatTimeItem;
import common.base.tools.sys.SystemTools;
import common.config.tools.config.ConfigTools3;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApiStatisticsReportTools {
    private static final Logger logger = LoggerFactory.getLogger(WebApiStatisticsReportTools.class);

    public static void reportSlowRequest(String key, long time) {
        long slowMin = ConfigTools3.getLong((String)"statistics.slow", (Long)200000L);
        if (slowMin == 0L || time < slowMin) {
            return;
        }
        logger.info("[SLOW]name:[{}] time[{}]", (Object)key, (Object)time);
        String metricName = String.format("%s_time_slow", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"time", (Object)time);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportCount(String key, long count) {
        String metricName = String.format("%s_count", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportTimeConsumed(String key, long count, long avg) {
        String metricName = String.format("%s_time_consumed", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)key);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count, (Object)"avg", (Object)avg);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportTimeConsumedByStatus(String key, StatTimeItem timeItem) {
        int level = ConfigTools3.getInt((String)String.format("statistics.level.%s", key), (Integer)0);
        if (level <= 0) {
            return;
        }
        long count = timeItem.getCountGELevel(level);
        if (count == 0L) {
            return;
        }
        String reportKey = String.format("%s.%s", timeItem.getKey(), key);
        String metricName = String.format("%s_time_status", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ImmutableMap tags = ImmutableMap.of((Object)"host", (Object)SystemTools.getHostname(), (Object)"item", (Object)reportKey);
        ImmutableMap values = ImmutableMap.of((Object)"count", (Object)count);
        MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
    }

    public static void reportQps(Map.Entry element) {
        String metricName = String.format("%s_api_qps", ConfigTools3.getString((String)"statistics.metric.prefix", (String)"common_statistics"));
        ServiceStatisticItem key = (ServiceStatisticItem)element.getKey();
        QpsItem value = (QpsItem)element.getValue();
        if (Objects.nonNull(key) && Objects.nonNull(value)) {
            logger.info("apiStatistics info : [{}]--[{}]", (Object)key.toString(), (Object)value.toString());
            ImmutableMap tags = ImmutableMap.of((Object)"apiName", (Object)key.getApiName(), (Object)"serverAddress", (Object)key.getServerAddress(), (Object)"httpCode", (Object)key.getHttpResponseCode(), (Object)"errCode", (Object)key.getErrCode(), (Object)"errMsg", (Object)key.getErrMsg());
            ImmutableMap values = ImmutableMap.of((Object)"count", (Object)value.getVisitCount(), (Object)"maxQps", (Object)(1000.0 / (double)value.getMinDurationMs()), (Object)"minQps", (Object)(1000.0 / (double)value.getMaxDurationMs()), (Object)"avgQps", (Object)(1000.0 / value.getAvgDurationMs()));
            MetricTools2.postEvent((String)metricName, (Map)tags, (Map)values);
        }
    }
}

