package common.web.tools.statistics.influxdb;

import org.influxdb.annotation.Column;
import org.influxdb.annotation.Measurement;

/**
 * @author Administrator
 */
@Measurement(name = "qps_info")
public class QpsInfo {

    @Column(name = "time")
    private long time;

    @Column(name = "api_name", tag = true)
    private String apiName;

    @Column(name = "server_address", tag = true)
    private String serverAddress;

    @Column(name = "server_port")
    private int serverPort;

    @Column(name = "http_response_code",tag = true)
    private int httpResponseCode;

    @Column(name = "err_code", tag = true)
    private int errCode;

    @Column(name = "err_msg")
    private String errMsg;

    @Column(name = "visit_count")
    private int visitCount;

    @Column(name = "max_qps")
    private double maxQps;

    @Column(name = "min_qps")
    private double minQps;

    @Column(name = "real_qps")
    private double realQps;

    public long getTime() {
        return time;
    }

    public String getApiName() {
        return apiName;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public int getServerPort() {
        return serverPort;
    }

    public int getHttpResponseCode() {
        return httpResponseCode;
    }

    public int getErrCode() {
        return errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public int getVisitCount() {
        return visitCount;
    }

    public double getMaxQps() {
        return maxQps;
    }

    public double getMinQps() {
        return minQps;
    }

    public double getRealQps() {
        return realQps;
    }

    public QpsInfo(Builder builder) {
        this.time = builder.time;
        this.apiName = builder.apiName;
        this.serverAddress = builder.serverAddress;
        this.serverPort = builder.serverPort;
        this.httpResponseCode = builder.httpResponseCode;
        this.errCode = builder.errCode;
        this.errMsg = builder.errMsg;
        this.visitCount = builder.visitCount;
        this.maxQps = builder.maxQps;
        this.minQps = builder.minQps;
        this.realQps = builder.realQps;
    }

    public static class Builder {
        private long time;

        private String apiName;

        private String serverAddress;

        private int serverPort;

        private int httpResponseCode;

        private int errCode;

        private String errMsg;

        private int visitCount;

        private double maxQps;

        private double minQps;

        private double realQps;

        public Builder time(long time) {
            this.time = time;
            return this;
        }

        public Builder apiName(String apiName) {
            this.apiName = apiName;
            return this;
        }

        public Builder serverAddress(String serverAddress) {
            this.serverAddress = serverAddress;
            return this;
        }

        public Builder serverPort(int serverPort) {
            this.serverPort = serverPort;
            return this;
        }

        public Builder httpResponseCode(int httpResponseCode) {
            this.httpResponseCode = httpResponseCode;
            return this;
        }

        public Builder errCode(int errCode) {
            this.errCode = errCode;
            return this;
        }

        public Builder errMsg(String errMsg) {
            this.errMsg = errMsg;
            return this;
        }

        public Builder visitCount(int visitCount) {
            this.visitCount = visitCount;
            return this;
        }

        public Builder maxQps(double maxQps) {
            this.maxQps = maxQps;
            return this;
        }

        public Builder minQps(double minQps) {
            this.minQps = minQps;
            return this;
        }

        public Builder realQps(double realQps) {
            this.realQps = realQps;
            return this;
        }

        public QpsInfo build() {
            return new QpsInfo(this);
        }
    }
}
