package common.web.tools.statistics.influxdb;

import common.config.tools.config.ConfigTools3;
import org.apache.commons.lang3.StringUtils;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Administrator
 */
public class InfluxDbConfig {

    private static InfluxDB influxDB;

    private static final Logger logger = LoggerFactory.getLogger(InfluxDbConfig.class);

    private final static Object synLock = new Object();


    public static InfluxDB initInfluxDb() {
        String influxDBUrl = ConfigTools3.getString("tve_influx_db_url", "http://147.135.36.62:8086");
        String userName = ConfigTools3.getString("tve_influx_db_user", "");
        String passWord = ConfigTools3.getString("tve_influx_db_pass", "");
        String dataBase = ConfigTools3.getString("tve_influx_db_instance", "goose_monitor");
        if (influxDB != null) {
            return influxDB;
        }
        logger.info("init influxDb,url[{}]--user[{}]--dataBase[{}]", influxDBUrl, userName, dataBase);
        synchronized (synLock) {
            if (influxDB == null) {
                if (StringUtils.isNotEmpty(userName) && StringUtils.isNotEmpty(passWord)) {
                    influxDB = InfluxDBFactory.connect(influxDBUrl, userName, passWord);
                } else {
                    influxDB = InfluxDBFactory.connect(influxDBUrl);
                }
                influxDB.setDatabase(dataBase);
                influxDB.setLogLevel(InfluxDB.LogLevel.BASIC);
            }
        }
        return influxDB;
    }
}
